/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.metric.Compatible;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.acquire.HL7ApplicationExtension;
import org.aoju.bus.image.metric.acquire.HL7DeviceExtension;
import org.aoju.bus.image.metric.internal.hl7.ERRSegment;
import org.aoju.bus.image.metric.internal.hl7.HL7Connection;
import org.aoju.bus.image.metric.internal.hl7.HL7Exception;
import org.aoju.bus.image.metric.internal.hl7.HL7MessageListener;
import org.aoju.bus.image.metric.internal.hl7.HL7Segment;
import org.aoju.bus.image.metric.internal.hl7.MLLPConnection;
import org.aoju.bus.image.metric.internal.hl7.UnparsedHL7Message;

public class HL7Application
implements Serializable {
    private final LinkedHashSet<String> acceptedSendingApplications = new LinkedHashSet();
    private final LinkedHashSet<String> otherApplicationNames = new LinkedHashSet();
    private final LinkedHashSet<String> acceptedMessageTypes = new LinkedHashSet();
    private final List<Connection> conns = new ArrayList<Connection>(1);
    private final Map<Class<? extends HL7ApplicationExtension>, HL7ApplicationExtension> extensions = new HashMap<Class<? extends HL7ApplicationExtension>, HL7ApplicationExtension>();
    private Device device;
    private String name;
    private String hl7DefaultCharacterSet = "ASCII";
    private String hl7SendingCharacterSet = "ASCII";
    private Boolean installed;
    private String description;
    private String[] applicationClusters = new String[0];
    private transient HL7MessageListener hl7MessageListener;

    public HL7Application() {
    }

    public HL7Application(String name) {
        this.setApplicationName(name);
    }

    public final Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        if (null != device) {
            if (null != this.device) {
                throw new IllegalStateException("already owned by " + this.device.getDeviceName());
            }
            for (Connection conn : this.conns) {
                if (conn.getDevice() == device) continue;
                throw new IllegalStateException(conn + " not owned by " + device.getDeviceName());
            }
        }
        this.device = device;
    }

    public String getApplicationName() {
        return this.name;
    }

    public void setApplicationName(String name) {
        HL7DeviceExtension ext;
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        HL7DeviceExtension hL7DeviceExtension = ext = null != this.device ? this.device.getDeviceExtension(HL7DeviceExtension.class) : null;
        if (null != ext) {
            ext.removeHL7Application(this.name);
        }
        this.name = name;
        if (null != ext) {
            ext.addHL7Application(this);
        }
    }

    public final String getHL7DefaultCharacterSet() {
        return this.hl7DefaultCharacterSet;
    }

    public final void setHL7DefaultCharacterSet(String hl7DefaultCharacterSet) {
        this.hl7DefaultCharacterSet = hl7DefaultCharacterSet;
    }

    public String getHL7SendingCharacterSet() {
        return this.hl7SendingCharacterSet;
    }

    public void setHL7SendingCharacterSet(String hl7SendingCharacterSet) {
        this.hl7SendingCharacterSet = hl7SendingCharacterSet;
    }

    public String[] getAcceptedSendingApplications() {
        return this.acceptedSendingApplications.toArray(new String[this.acceptedSendingApplications.size()]);
    }

    public void setAcceptedSendingApplications(String ... names) {
        this.acceptedSendingApplications.clear();
        for (String name : names) {
            this.acceptedSendingApplications.add(name);
        }
    }

    public String[] getOtherApplicationNames() {
        return this.otherApplicationNames.toArray(new String[this.otherApplicationNames.size()]);
    }

    public void setOtherApplicationNames(String ... names) {
        this.otherApplicationNames.clear();
        for (String name : names) {
            this.otherApplicationNames.add(name);
        }
    }

    public boolean isOtherApplicationName(String name) {
        return this.otherApplicationNames.contains(name);
    }

    public String[] getAcceptedMessageTypes() {
        return this.acceptedMessageTypes.toArray(new String[this.acceptedMessageTypes.size()]);
    }

    public void setAcceptedMessageTypes(String ... types) {
        this.acceptedMessageTypes.clear();
        for (String name : types) {
            this.acceptedMessageTypes.add(name);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getApplicationClusters() {
        return this.applicationClusters;
    }

    public void setApplicationClusters(String[] applicationClusters) {
        this.applicationClusters = applicationClusters;
    }

    public boolean isInstalled() {
        return null != this.device && this.device.isInstalled() && (null == this.installed || this.installed != false);
    }

    public final Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean installed) {
        if (null != installed && installed.booleanValue() && null != this.device && !this.device.isInstalled()) {
            throw new IllegalStateException("owning device not installed");
        }
        this.installed = installed;
    }

    public HL7MessageListener getHL7MessageListener() {
        HL7MessageListener listener = this.hl7MessageListener;
        if (null != listener) {
            return listener;
        }
        HL7DeviceExtension hl7Ext = this.device.getDeviceExtension(HL7DeviceExtension.class);
        return null != hl7Ext ? hl7Ext.getHL7MessageListener() : null;
    }

    public final void setHL7MessageListener(HL7MessageListener listener) {
        this.hl7MessageListener = listener;
    }

    public void addConnection(Connection conn) {
        if (conn.getProtocol() != Connection.Protocol.HL7) {
            throw new IllegalArgumentException("protocol != HL7 - " + conn.getProtocol());
        }
        if (null != this.device && this.device != conn.getDevice()) {
            throw new IllegalStateException(conn + " not contained by " + this.device.getDeviceName());
        }
        this.conns.add(conn);
    }

    public boolean removeConnection(Connection conn) {
        return this.conns.remove(conn);
    }

    public List<Connection> getConnections() {
        return this.conns;
    }

    public UnparsedHL7Message onMessage(Connection conn, Socket s, UnparsedHL7Message msg) throws HL7Exception {
        HL7Segment msh = msg.msh();
        if (!this.isInstalled() || !this.conns.contains(conn)) {
            throw new HL7Exception(new ERRSegment(msh).setHL7ErrorCode("103").setErrorLocation("MSH^1^5").setUserMessage("Receiving Application not recognized"));
        }
        if (!this.acceptedSendingApplications.isEmpty() && !this.acceptedSendingApplications.contains(msh.getSendingApplicationWithFacility())) {
            throw new HL7Exception(new ERRSegment(msh).setHL7ErrorCode("103").setErrorLocation("MSH^1^3").setUserMessage("Sending Application not recognized"));
        }
        String messageType = msh.getMessageType();
        if (!this.acceptedMessageTypes.contains("*") && !this.acceptedMessageTypes.contains(messageType)) {
            throw new HL7Exception(new ERRSegment(msh).setHL7ErrorCode(this.unsupportedMessageTypeOrEventCode(messageType.substring(0, 3))).setUserMessage("Message Type not supported"));
        }
        HL7MessageListener listener = this.getHL7MessageListener();
        if (null == listener) {
            throw new HL7Exception(new ERRSegment(msh).setHL7ErrorCode("207").setUserMessage("No HL7 Message Listener configured"));
        }
        return listener.onMessage(this, conn, s, msg);
    }

    private String unsupportedMessageTypeOrEventCode(String messageType) {
        for (String acceptedMessageType : this.acceptedMessageTypes) {
            if (!acceptedMessageType.startsWith(messageType)) continue;
            return "201";
        }
        return "200";
    }

    public MLLPConnection connect(Connection remote) throws IOException, InternalException, GeneralSecurityException {
        return this.connect(this.findCompatibleConnection(remote), remote);
    }

    public MLLPConnection connect(HL7Application remote) throws IOException, InternalException, GeneralSecurityException {
        Compatible cc = this.findCompatibleConnection(remote);
        return this.connect(cc.getLocalConnection(), cc.getRemoteConnection());
    }

    public MLLPConnection connect(Connection local, Connection remote) throws IOException, InternalException, GeneralSecurityException {
        this.checkDevice();
        this.checkInstalled();
        Socket sock = local.connect(remote);
        sock.setSoTimeout(local.getResponseTimeout());
        return new MLLPConnection(sock);
    }

    public HL7Connection open(Connection remote) throws IOException, InternalException, GeneralSecurityException {
        return new HL7Connection(this, this.connect(remote));
    }

    public HL7Connection open(HL7Application remote) throws IOException, InternalException, GeneralSecurityException {
        return new HL7Connection(this, this.connect(remote));
    }

    public HL7Connection open(Connection local, Connection remote) throws IOException, InternalException, GeneralSecurityException {
        return new HL7Connection(this, this.connect(local, remote));
    }

    public Compatible findCompatibleConnection(HL7Application remote) throws InternalException {
        for (Connection remoteConn : remote.conns) {
            if (!remoteConn.isInstalled() || !remoteConn.isServer()) continue;
            for (Connection conn : this.conns) {
                if (!conn.isInstalled() || !conn.isCompatible(remoteConn)) continue;
                return new Compatible(conn, remoteConn);
            }
        }
        throw new InternalException("No compatible connection to " + remote.getApplicationName() + " available on " + this.name);
    }

    public Connection findCompatibleConnection(Connection remoteConn) throws InternalException {
        for (Connection conn : this.conns) {
            if (!conn.isInstalled() || !conn.isCompatible(remoteConn)) continue;
            return conn;
        }
        throw new InternalException("No compatible connection to " + remoteConn + " available on " + this.name);
    }

    private void checkInstalled() {
        if (!this.isInstalled()) {
            throw new IllegalStateException("Not installed");
        }
    }

    private void checkDevice() {
        if (null == this.device) {
            throw new IllegalStateException("Not attached to Device");
        }
    }

    public void reconfigure(HL7Application src) {
        this.setHL7ApplicationAttributes(src);
        this.device.reconfigureConnections(this.conns, src.conns);
        this.reconfigureHL7ApplicationExtensions(src);
    }

    private void reconfigureHL7ApplicationExtensions(HL7Application from) {
        Iterator<Class<? extends HL7ApplicationExtension>> it = this.extensions.keySet().iterator();
        while (it.hasNext()) {
            if (from.extensions.containsKey(it.next())) continue;
            it.remove();
        }
        for (HL7ApplicationExtension src : from.extensions.values()) {
            Class<?> clazz = src.getClass();
            HL7ApplicationExtension ext = this.extensions.get(clazz);
            if (null == ext) {
                try {
                    ext = (HL7ApplicationExtension)clazz.newInstance();
                    this.addHL7ApplicationExtension(ext);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to instantiate " + clazz.getName(), e);
                }
            }
            ext.reconfigure(src);
        }
    }

    protected void setHL7ApplicationAttributes(HL7Application src) {
        this.description = src.description;
        this.applicationClusters = src.applicationClusters;
        this.hl7DefaultCharacterSet = src.hl7DefaultCharacterSet;
        this.hl7SendingCharacterSet = src.hl7SendingCharacterSet;
        this.acceptedSendingApplications.clear();
        this.acceptedSendingApplications.addAll(src.acceptedSendingApplications);
        this.otherApplicationNames.clear();
        this.otherApplicationNames.addAll(src.otherApplicationNames);
        this.acceptedMessageTypes.clear();
        this.acceptedMessageTypes.addAll(src.acceptedMessageTypes);
        this.installed = src.installed;
    }

    public void addHL7ApplicationExtension(HL7ApplicationExtension ext) {
        Class<?> clazz = ext.getClass();
        if (this.extensions.containsKey(clazz)) {
            throw new IllegalStateException("already contains AE Extension:" + clazz);
        }
        ext.setHL7Application(this);
        this.extensions.put(clazz, ext);
    }

    public boolean removeHL7ApplicationExtension(HL7ApplicationExtension ext) {
        if (null == this.extensions.remove(ext.getClass())) {
            return false;
        }
        ext.setHL7Application(null);
        return true;
    }

    public Collection<HL7ApplicationExtension> listHL7ApplicationExtensions() {
        return this.extensions.values();
    }

    public <T extends HL7ApplicationExtension> T getHL7ApplicationExtension(Class<T> clazz) {
        return (T)this.extensions.get(clazz);
    }

    public <T extends HL7ApplicationExtension> T getHL7AppExtensionNotNull(Class<T> clazz) {
        T hl7AppExt = this.getHL7ApplicationExtension(clazz);
        if (null == hl7AppExt) {
            throw new IllegalStateException("No " + clazz.getName() + " configured for HL7 Application: " + this.name);
        }
        return hl7AppExt;
    }
}

