/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class HL7Segment
implements Serializable {
    private static final AtomicInteger nextMessageControlID = new AtomicInteger(new Random().nextInt());
    private final char fieldSeparator;
    private final String encodingCharacters;
    private String[] fields;

    public HL7Segment(int size, char fieldSeparator, String encodingCharacters) {
        if (size <= 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.fieldSeparator = fieldSeparator;
        this.encodingCharacters = encodingCharacters;
        this.fields = new String[size];
    }

    public HL7Segment(int size) {
        this(size, '|', "^~\\&");
    }

    public HL7Segment(String s, char fieldSeparator, String encodingCharacters) {
        this.fieldSeparator = fieldSeparator;
        this.encodingCharacters = encodingCharacters;
        this.fields = HL7Segment.split(s, fieldSeparator);
    }

    public static String concat(String[] ss, char delim) {
        int n = ss.length;
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            String s = ss[0];
            return null != s ? s : "";
        }
        int len = n - 1;
        for (String s : ss) {
            if (null == s) continue;
            len += s.length();
        }
        char[] cs = new char[len];
        int off = 0;
        for (int i = 0; i < n; ++i) {
            String s;
            if (i != 0) {
                cs[off++] = delim;
            }
            if (null == (s = ss[i])) continue;
            int l = s.length();
            s.getChars(0, l, cs, off);
            off += l;
        }
        return new String(cs);
    }

    public static String[] split(String s, char delim) {
        int count = 1;
        int delimPos = -1;
        while ((delimPos = s.indexOf(delim, delimPos + 1)) >= 0) {
            ++count;
        }
        if (count == 1) {
            return new String[]{s};
        }
        String[] ss = new String[count];
        int delimPos2 = s.length();
        while (--count >= 0) {
            delimPos = s.lastIndexOf(delim, delimPos2 - 1);
            ss[count] = s.substring(delimPos + 1, delimPos2);
            delimPos2 = delimPos;
        }
        return ss;
    }

    public static HL7Segment parseMSH(byte[] b, int size) {
        return HL7Segment.parseMSH(b, size, new ParsePosition(0));
    }

    public static HL7Segment parseMSH(byte[] b, int size, ParsePosition pos) {
        String s = HL7Segment.parse(b, size, pos, null);
        if (s.length() < 8) {
            throw new IllegalArgumentException("Invalid MSH Segment: " + s);
        }
        return new HL7Segment(s, s.charAt(3), s.substring(4, 8));
    }

    static HL7Segment parse(byte[] b, int size, ParsePosition pos, char fieldSeparator, String encodingCharacters, String charsetName) {
        String s = HL7Segment.parse(b, size, pos, charsetName);
        return null != s ? new HL7Segment(s, fieldSeparator, encodingCharacters) : null;
    }

    private static String parse(byte[] b, int size, ParsePosition pos, String charsetName) {
        int off;
        int end;
        for (end = off = pos.getIndex(); end < size && b[end] != 13 && b[end] != 10; ++end) {
        }
        int len = end - off;
        if (len == 0) {
            return null;
        }
        if (++end < size && (b[end] == 13 || b[end] == 10)) {
            ++end;
        }
        pos.setIndex(end);
        try {
            return null != charsetName ? new String(b, off, len, charsetName) : new String(b, off, len);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("charsetName: " + charsetName);
        }
    }

    public static String nextMessageControlID() {
        return Integer.toString(nextMessageControlID.getAndIncrement() & Integer.MAX_VALUE);
    }

    public static String timeStamp(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmss.SSS").format(date);
    }

    public static HL7Segment makeMSH() {
        return HL7Segment.makeMSH(21, '|', "^~\\&");
    }

    public static HL7Segment makeMSH(int size, char fieldSeparator, String encodingCharacters) {
        HL7Segment msh = new HL7Segment(size, fieldSeparator, encodingCharacters);
        msh.setField(0, "MSH");
        msh.setField(1, encodingCharacters);
        msh.setField(6, HL7Segment.timeStamp(new Date()));
        msh.setField(9, HL7Segment.nextMessageControlID());
        msh.setField(10, "P");
        msh.setField(11, "2.5");
        return msh;
    }

    public final char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public final char getComponentSeparator() {
        return this.encodingCharacters.charAt(0);
    }

    public final char getRepetitionSeparator() {
        return this.encodingCharacters.charAt(1);
    }

    public final char getEscapeCharacter() {
        return this.encodingCharacters.charAt(2);
    }

    public final char getSubcomponentSeparator() {
        return this.encodingCharacters.charAt(3);
    }

    public final String getEncodingCharacters() {
        return this.encodingCharacters;
    }

    public void setField(int index, String value) {
        if (index >= this.fields.length) {
            this.fields = Arrays.copyOf(this.fields, index + 1);
        }
        this.fields[index] = value;
    }

    public String getField(int index, String defVal) {
        String val = index < this.fields.length ? this.fields[index] : null;
        return null != val && !val.isEmpty() ? val : defVal;
    }

    public int size() {
        return this.fields.length;
    }

    public String getSendingApplicationWithFacility() {
        return this.getField(2, "") + "|" + this.getField(3, "");
    }

    public void setSendingApplicationWithFacility(String s) {
        String[] ss = HL7Segment.split(s, '|');
        this.setField(2, ss[0]);
        if (ss.length > 1) {
            this.setField(3, ss[1]);
        }
    }

    public String getReceivingApplicationWithFacility() {
        return this.getField(4, "") + "|" + this.getField(5, "");
    }

    public void setReceivingApplicationWithFacility(String s) {
        String[] ss = HL7Segment.split(s, '|');
        this.setField(4, ss[0]);
        if (ss.length > 1) {
            this.setField(5, ss[1]);
        }
    }

    public String getMessageType() {
        String s = this.getField(8, "").replace(this.getComponentSeparator(), '^');
        int end = s.indexOf(94, s.indexOf(94) + 1);
        return end > 0 ? s.substring(0, end) : s;
    }

    public String getMessageControlID() {
        return this.getField(9, null);
    }

    public String toString() {
        return HL7Segment.concat(this.fields, this.fieldSeparator);
    }
}

