/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.pdu;

import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.Property;

public class Presentation {
    public static final int ACCEPTANCE = 0;
    public static final int USER_REJECTION = 1;
    public static final int PROVIDER_REJECTION = 2;
    public static final int ABSTRACT_SYNTAX_NOT_SUPPORTED = 3;
    public static final int TRANSFER_SYNTAX_NOT_SUPPORTED = 4;
    private static final String[] RESULTS = new String[]{"0 - acceptance", "1 - user-rejection", "2 - no-reason (provider rejection)", "3 - abstract-syntax-not-supported (provider rejection)", "4 - transfer-syntaxes-not-supported (provider rejection)"};
    private final int pcid;
    private final int result;
    private final String as;
    private final String[] tss;

    public Presentation(int pcid, int result, String as, String ... tss) {
        this.pcid = pcid;
        this.result = result;
        this.as = as;
        this.tss = tss;
    }

    public Presentation(int pcid, String as, String ... tss) {
        this(pcid, 0, as, tss);
    }

    public Presentation(int pcid, int result, String ts) {
        this(pcid, result, null, ts);
    }

    private static String resultAsString(int result) {
        try {
            return RESULTS[result];
        }
        catch (IndexOutOfBoundsException e) {
            return Integer.toString(result);
        }
    }

    public final int getPCID() {
        return this.pcid;
    }

    public final int getResult() {
        return this.result;
    }

    public boolean isAccepted() {
        return this.result == 0;
    }

    public final String getAbstractSyntax() {
        return this.as;
    }

    public final String[] getTransferSyntaxes() {
        return this.tss;
    }

    public boolean containsTransferSyntax(String ts) {
        for (String ts0 : this.tss) {
            if (!ts.equals(ts0)) continue;
            return true;
        }
        return false;
    }

    public String getTransferSyntax() {
        return this.tss[0];
    }

    public int length() {
        int len = 4;
        if (null != this.as) {
            len += 4 + this.as.length();
        }
        for (String ts : this.tss) {
            len += 4 + ts.length();
        }
        return len;
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder sb) {
        sb.append("  PresentationContext[id: ").append(this.pcid).append(Property.LINE_SEPARATOR);
        if (null != this.as) {
            UID.promptTo(this.as, sb.append("    as: "));
        } else {
            sb.append("    result: ").append(Presentation.resultAsString(this.result));
        }
        sb.append(Property.LINE_SEPARATOR);
        for (String ts : this.tss) {
            UID.promptTo(ts, sb.append("    ts: ")).append(Property.LINE_SEPARATOR);
        }
        return sb.append("  ]");
    }
}

