/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.aoju.bus.image.nimble.opencv.NativeImageReader;

public class NativeJ2kImageReaderSpi
extends ImageReaderSpi {
    public static final String[] SUFFIXES = new String[]{"jp2", "jp2k", "j2k", "j2c"};
    public static final String[] NAMES = new String[]{"jpeg2000-cv", "jpeg2000", "JP2KSimpleBox", "jpeg 2000", "JPEG 2000", "JPEG2000"};
    public static final String[] MIMES = new String[]{"image/jp2", "image/jp2k", "image/j2k", "image/j2c"};

    public NativeJ2kImageReaderSpi() {
        super("Bus Team", "1.5", NAMES, SUFFIXES, MIMES, NativeImageReader.class.getName(), new Class[]{ImageInputStream.class}, new String[0], false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Natively-accelerated JPEG2000 Image Reader (OpenJPEG based)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream iis = (ImageInputStream)source;
        iis.mark();
        try {
            int marker = iis.read() << 8 | iis.read();
            if (marker == 65359) {
                boolean bl = true;
                return bl;
            }
            iis.reset();
            iis.mark();
            byte[] b = new byte[12];
            iis.readFully(b);
            if (b[0] != 0 || b[1] != 0 || b[2] != 0 || b[3] != 12) {
                boolean bl = false;
                return bl;
            }
            if ((b[4] & 0xFF) != 106 || (b[5] & 0xFF) != 80 || (b[6] & 0xFF) != 32 || (b[7] & 0xFF) != 32) {
                boolean bl = false;
                return bl;
            }
            boolean bl = (b[8] & 0xFF) != 13 || (b[9] & 0xFF) != 10 || (b[10] & 0xFF) != 135 || (b[11] & 0xFF) != 10;
            return bl;
        }
        finally {
            iis.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new NativeImageReader(this, true);
    }
}

