/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.aoju.bus.logger.Logger;

public class FixLO2UN
extends SimpleFileVisitor<Path> {
    private final ByteBuffer buffer = ByteBuffer.wrap(new byte[]{85, 78, 0, 0, 0, 0, 0, 0}).order(ByteOrder.LITTLE_ENDIAN);
    private final Path srcPath;
    private final Path destPath;
    private final Dest dest;

    private FixLO2UN(Path srcPath, Path destPath, Dest dest) {
        this.srcPath = srcPath;
        this.destPath = destPath;
        this.dest = dest;
    }

    @Override
    public FileVisitResult visitFile(Path srcFile, BasicFileAttributes attrs) throws IOException {
        Path dstFile = this.dest.dstFile(srcFile, this.srcPath, this.destPath);
        Path dstDir = dstFile.getParent();
        if (null != dstDir) {
            Files.createDirectories(dstDir, new FileAttribute[0]);
        }
        try (FileChannel ifc = (FileChannel)Files.newByteChannel(srcFile, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);
             FileChannel ofc = (FileChannel)Files.newByteChannel(dstFile, EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), new FileAttribute[0]);){
            int length;
            MappedByteBuffer mbb = ifc.map(FileChannel.MapMode.READ_ONLY, 0L, ifc.size());
            mbb.order(ByteOrder.LITTLE_ENDIAN);
            mbb.mark();
            while ((length = this.correctLength(mbb)) > 0) {
                int position = mbb.position();
                Logger.info("  %d: (%02X%02X,%02X%02X) LO #%d -> UN #%d%n", position - 6, mbb.get(position - 5), mbb.get(position - 6), mbb.get(position - 3), mbb.get(position - 4), length & 0xFFF, length);
                mbb.reset().limit(position - 2);
                ofc.write(mbb);
                this.buffer.putInt(4, length).rewind();
                ofc.write(this.buffer);
                mbb.limit(position + 2 + length).position(position + 2);
                ofc.write(mbb);
                mbb.limit((int)ifc.size()).mark();
            }
            mbb.reset();
            ofc.write(mbb);
        }
        return FileVisitResult.CONTINUE;
    }

    private int correctLength(MappedByteBuffer mbb) {
        while (mbb.remaining() > 9) {
            if (mbb.getShort() != 20300 || mbb.get(mbb.position() - 3) != 0 || mbb.get(mbb.position() - 6) % 2 == 0) continue;
            int length = mbb.getShort(mbb.position()) & 0xFFFF;
            if (this.isVRCode(mbb.getShort(mbb.position() + 6 + length))) continue;
            return this.correctLength(mbb, length);
        }
        return 0;
    }

    private boolean isVRCode(int code) {
        switch (code) {
            case 16708: 
            case 16975: 
            case 17237: 
            case 17478: 
            case 17487: 
            case 17729: 
            case 17999: 
            case 18515: 
            case 18773: 
            case 19526: 
            case 19535: 
            case 19539: 
            case 19541: 
            case 19796: 
            case 20048: 
            case 20053: 
            case 20300: 
            case 20819: 
            case 21077: 
            case 21313: 
            case 21315: 
            case 21316: 
            case 21321: 
            case 21331: 
            case 21333: 
            case 21569: 
            case 21572: 
            case 21580: 
            case 21587: 
            case 21589: 
            case 22351: {
                return true;
            }
        }
        return false;
    }

    private int correctLength(MappedByteBuffer mbb, int length) {
        while (!this.isVRCode(mbb.getShort(mbb.position() + 6 + (length += 65536)))) {
        }
        return length;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Dest {
        FILE,
        DIRECTORY{

            @Override
            Path dstFile(Path srcFile, Path srcPath, Path destPath) {
                return destPath.resolve(srcFile == srcPath ? srcFile.getFileName() : srcPath.relativize(srcFile));
            }
        };


        static Dest of(Path destPath) {
            return Files.isDirectory(destPath, new LinkOption[0]) ? DIRECTORY : FILE;
        }

        Path dstFile(Path srcFile, Path srcPath, Path destPath) {
            return destPath;
        }
    }
}

