/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.console;

import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.map.Dictionary;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.AbstractAware;
import org.aoju.bus.logger.level.Level;

public class ConsoleLog
extends AbstractAware {
    private static final String logFormat = "[{date}] [{level}] {name}: {msg}";
    private static Level currentLevel = Level.DEBUG;
    private final String name;

    public ConsoleLog(Class<?> clazz) {
        this.name = null == clazz ? "null" : clazz.getName();
    }

    public ConsoleLog(String name) {
        this.name = name;
    }

    public static void setLevel(Level customLevel) {
        Assert.notNull(customLevel);
        currentLevel = customLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTrace() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebug() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfo() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarn() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.WARN, t, format, arguments);
    }

    @Override
    public boolean isError() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        Dictionary dictionary = Dictionary.of().set("date", DateKit.now()).set("level", level.toString()).set("name", this.name).set("msg", StringKit.format((CharSequence)format, arguments));
        String logMsg = StringKit.format((CharSequence)logFormat, dictionary);
        if (level.ordinal() >= Level.WARN.ordinal()) {
            Console.error(t, logMsg, new Object[0]);
        } else {
            Console.log(t, logMsg, new Object[0]);
        }
    }

    @Override
    public boolean isEnabled(Level level) {
        return currentLevel.compareTo(level) <= 0;
    }
}

