/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.mapper.annotation.RegisterMapper;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.builder.resolve.EntityResolve;
import org.aoju.bus.mapper.entity.Config;
import org.aoju.bus.mapper.provider.EmptyProvider;
import org.aoju.bus.mapper.reflect.Reflector;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;

public class MapperBuilder {
    private List<Class<?>> registerClass = new ArrayList();
    private Map<Class<?>, MapperTemplate> registerMapper = new ConcurrentHashMap();
    private Config config = new Config();

    public MapperBuilder() {
    }

    public MapperBuilder(Properties properties) {
        this();
        this.setProperties(properties);
    }

    private MapperTemplate fromMapperClass(Class<?> mapperClass) {
        MapperTemplate mapperTemplate;
        Method[] methods = mapperClass.getDeclaredMethods();
        Class templateClass = null;
        Class tempClass = null;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods) {
            if (method.isAnnotationPresent(SelectProvider.class)) {
                provider = method.getAnnotation(SelectProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(InsertProvider.class)) {
                provider = method.getAnnotation(InsertProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(DeleteProvider.class)) {
                provider = method.getAnnotation(DeleteProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(UpdateProvider.class)) {
                provider = method.getAnnotation(UpdateProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            }
            if (templateClass == null) {
                templateClass = tempClass;
                continue;
            }
            if (templateClass == tempClass) continue;
            Logger.error("\u4e00\u4e2a\u901a\u7528Mapper\u4e2d\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2aMapperTemplate\u5b50\u7c7b!", new Object[0]);
            throw new InternalException("\u4e00\u4e2a\u901a\u7528Mapper\u4e2d\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2aMapperTemplate\u5b50\u7c7b!");
        }
        if (templateClass == null || !MapperTemplate.class.isAssignableFrom(templateClass)) {
            templateClass = EmptyProvider.class;
        }
        try {
            mapperTemplate = (MapperTemplate)templateClass.getConstructor(Class.class, MapperBuilder.class).newInstance(mapperClass, this);
        }
        catch (Exception e) {
            Logger.error("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + e, e);
            throw new InternalException("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + e.getMessage());
        }
        for (String methodName : methodSet) {
            try {
                mapperTemplate.addMethodMap(methodName, templateClass.getMethod(methodName, MappedStatement.class));
            }
            catch (NoSuchMethodException e) {
                Logger.error(templateClass.getCanonicalName() + "\u4e2d\u7f3a\u5c11" + methodName + "\u65b9\u6cd5!", e);
                throw new InternalException(templateClass.getCanonicalName() + "\u4e2d\u7f3a\u5c11" + methodName + "\u65b9\u6cd5!");
            }
        }
        return mapperTemplate;
    }

    public void registerMapper(Class<?> mapperClass) {
        Class<?>[] interfaces;
        if (!this.registerMapper.containsKey(mapperClass)) {
            this.registerClass.add(mapperClass);
            this.registerMapper.put(mapperClass, this.fromMapperClass(mapperClass));
        }
        if ((interfaces = mapperClass.getInterfaces()) != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                this.registerMapper(anInterface);
            }
        }
    }

    public void registerMapper(String mapperClass) {
        try {
            this.registerMapper(Class.forName(mapperClass));
        }
        catch (ClassNotFoundException e) {
            Logger.error("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!", e);
            throw new InternalException("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!");
        }
    }

    public MapperTemplate isMapperMethod(String msId) {
        MapperTemplate mapperTemplate = this.getMapperTemplateByMsId(msId);
        if (mapperTemplate == null) {
            try {
                Class<?> mapperClass = Reflector.getMapperClass(msId);
                if (mapperClass.isInterface() && this.hasRegisterMapper(mapperClass)) {
                    mapperTemplate = this.getMapperTemplateByMsId(msId);
                }
            }
            catch (Exception e) {
                Logger.warn("\u7279\u6b8a\u60c5\u51b5: " + e, new Object[0]);
            }
        }
        return mapperTemplate;
    }

    public MapperTemplate getMapperTemplateByMsId(String msId) {
        for (Map.Entry<Class<?>, MapperTemplate> entry : this.registerMapper.entrySet()) {
            if (!entry.getValue().supportMethod(msId)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean isExtendCommonMapper(Class<?> mapperInterface) {
        for (Class<?> mapperClass : this.registerClass) {
            if (!mapperClass.isAssignableFrom(mapperInterface)) continue;
            return true;
        }
        return this.hasRegisterMapper(mapperInterface);
    }

    private boolean hasRegisterMapper(Class<?> mapperInterface) {
        Class<?>[] interfaces = mapperInterface.getInterfaces();
        boolean hasRegisterMapper = false;
        if (interfaces != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                if (anInterface.isAnnotationPresent(RegisterMapper.class)) {
                    hasRegisterMapper = true;
                    if (this.registerMapper.containsKey(anInterface)) continue;
                    this.registerMapper(anInterface);
                    continue;
                }
                if (!this.hasRegisterMapper(anInterface)) continue;
                hasRegisterMapper = true;
            }
        }
        return hasRegisterMapper;
    }

    public void processConfiguration(Configuration configuration) {
        this.processConfiguration(configuration, null);
    }

    public void processConfiguration(Configuration configuration, Class<?> mapperInterface) {
        String prefix = mapperInterface != null ? mapperInterface.getCanonicalName() : "";
        for (Object object : new ArrayList(configuration.getMappedStatements())) {
            MappedStatement ms;
            if (!(object instanceof MappedStatement) || !(ms = (MappedStatement)object).getId().startsWith(prefix)) continue;
            this.processMappedStatement(ms);
        }
    }

    public void processMappedStatement(MappedStatement ms) {
        MapperTemplate mapperTemplate = this.isMapperMethod(ms.getId());
        if (mapperTemplate != null && ms.getSqlSource() instanceof ProviderSqlSource) {
            this.setSqlSource(ms, mapperTemplate);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
        if (config.getResolveClass() != null) {
            try {
                EntityBuilder.setResolve(config.getResolveClass().getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                Logger.error("\u521b\u5efa " + config.getResolveClass().getCanonicalName() + " \u5b9e\u4f8b\u5931\u8d25\uff0c\u8bf7\u4fdd\u8bc1\u8be5\u7c7b\u6709\u9ed8\u8ba4\u7684\u6784\u9020\u65b9\u6cd5!", e);
                throw new InternalException("\u521b\u5efa " + config.getResolveClass().getCanonicalName() + " \u5b9e\u4f8b\u5931\u8d25\uff0c\u8bf7\u4fdd\u8bc1\u8be5\u7c7b\u6709\u9ed8\u8ba4\u7684\u6784\u9020\u65b9\u6cd5!", e);
            }
        }
        if (config.getMappers() != null && config.getMappers().size() > 0) {
            for (Class mapperClass : config.getMappers()) {
                this.registerMapper(mapperClass);
            }
        }
    }

    public void setProperties(Properties properties) {
        String mapper;
        String resolveClass;
        this.config.setProperties(properties);
        if (properties != null && StringKit.isNotEmpty(resolveClass = properties.getProperty("resolveClass"))) {
            try {
                EntityBuilder.setResolve((EntityResolve)Class.forName(resolveClass).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                Logger.error("\u521b\u5efa " + resolveClass + " \u5b9e\u4f8b\u5931\u8d25!", e);
                throw new InternalException("\u521b\u5efa " + resolveClass + " \u5b9e\u4f8b\u5931\u8d25!", e);
            }
        }
        if (properties != null && StringKit.isNotEmpty(mapper = properties.getProperty("mappers"))) {
            String[] mappers;
            for (String mapperClass : mappers = mapper.split(",")) {
                if (mapperClass.length() <= 0) continue;
                this.registerMapper(mapperClass);
            }
        }
    }

    public void setSqlSource(MappedStatement ms, MapperTemplate mapperTemplate) {
        try {
            if (mapperTemplate != null) {
                mapperTemplate.setSqlSource(ms);
            }
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }
}

