/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.excel.sax;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.excel.ExcelSaxKit;
import org.aoju.bus.office.excel.cell.FormulaCellValue;
import org.aoju.bus.office.excel.sax.AttributeName;
import org.aoju.bus.office.excel.sax.CellDataType;
import org.aoju.bus.office.excel.sax.ElementName;
import org.aoju.bus.office.excel.sax.RowHandler;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetSaxHandler
extends DefaultHandler {
    private final TextBuilder lastContent = new TextBuilder();
    private final TextBuilder lastFormula = new TextBuilder();
    protected StylesTable stylesTable;
    protected SharedStrings sharedStrings;
    protected int sheetIndex;
    protected int index;
    protected RowHandler rowHandler;
    private int curCell;
    private CellDataType cellDataType;
    private long rowNumber;
    private String curCoordinate;
    private ElementName curElementName;
    private String preCoordinate;
    private String maxCellCoordinate;
    private XSSFCellStyle xssfCellStyle;
    private String numFmtString;
    private boolean isInSheetData;
    private List<Object> rowCellList = new ArrayList<Object>();

    public SheetSaxHandler(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    public void setRowHandler(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        ElementName name;
        if ("sheetData".equals(qName)) {
            this.isInSheetData = true;
            return;
        }
        if (!this.isInSheetData) {
            return;
        }
        this.curElementName = name = ElementName.of(qName);
        if (null != name) {
            switch (name) {
                case row: {
                    this.startRow(attributes);
                    break;
                }
                case c: {
                    this.startCell(attributes);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("sheetData".equals(qName)) {
            this.isInSheetData = false;
            return;
        }
        if (!this.isInSheetData) {
            return;
        }
        this.curElementName = null;
        if (ElementName.c.match(qName)) {
            this.endCell();
        } else if (ElementName.row.match(qName)) {
            this.endRow();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.isInSheetData) {
            return;
        }
        ElementName elementName = this.curElementName;
        if (null != elementName) {
            switch (elementName) {
                case v: {
                    this.lastContent.append(ch, start, length);
                    break;
                }
                case f: {
                    this.lastFormula.append(ch, start, length);
                }
            }
        } else {
            this.lastContent.append(ch, start, length);
        }
    }

    private void startRow(Attributes attributes) {
        String rValue = AttributeName.r.getValue(attributes);
        if (null != rValue) {
            this.rowNumber = Long.parseLong(rValue) - 1L;
        }
    }

    private void startCell(Attributes attributes) {
        String tempCurCoordinate = AttributeName.r.getValue(attributes);
        this.preCoordinate = this.preCoordinate == null ? String.valueOf('@') : this.curCoordinate;
        this.curCoordinate = tempCurCoordinate;
        this.setCellType(attributes);
        this.lastContent.reset();
        this.lastFormula.reset();
    }

    private void endRow() {
        if (this.index == 0) {
            this.maxCellCoordinate = this.curCoordinate;
        }
        if (this.maxCellCoordinate != null) {
            this.fillBlankCell(this.curCoordinate, this.maxCellCoordinate, true);
        }
        this.rowHandler.handle(this.sheetIndex, this.rowNumber, this.rowCellList);
        this.rowCellList = new ArrayList<Object>(this.curCell + 1);
        ++this.index;
        this.curCell = 0;
        this.curCoordinate = null;
        this.preCoordinate = null;
    }

    private void endCell() {
        this.fillBlankCell(this.preCoordinate, this.curCoordinate, false);
        String contentStr = StringKit.trim(this.lastContent);
        Object value = ExcelSaxKit.getDataValue(this.cellDataType, contentStr, this.sharedStrings, this.numFmtString);
        if (!this.lastFormula.isEmpty()) {
            value = new FormulaCellValue(StringKit.trim(this.lastFormula), value);
        }
        this.addCellValue(this.curCell++, value);
    }

    private void addCellValue(int index, Object value) {
        this.rowCellList.add(index, value);
        this.rowHandler.handleCell(this.sheetIndex, this.rowNumber, index, value, (CellStyle)this.xssfCellStyle);
    }

    private void fillBlankCell(String preCoordinate, String curCoordinate, boolean isEnd) {
        if (!curCoordinate.equals(preCoordinate)) {
            int len = ExcelSaxKit.countNullCell(preCoordinate, curCoordinate);
            if (isEnd) {
                // empty if block
            }
            while (true) {
                int n = ++len;
                --len;
                if (n <= 0) break;
                this.addCellValue(this.curCell++, "");
            }
        }
    }

    private void setCellType(Attributes attributes) {
        String xfIndexStr;
        this.numFmtString = "";
        this.cellDataType = CellDataType.of(AttributeName.t.getValue(attributes));
        if (null != this.stylesTable && null != (xfIndexStr = AttributeName.s.getValue(attributes))) {
            this.xssfCellStyle = this.stylesTable.getStyleAt(Integer.parseInt(xfIndexStr));
            short numFmtIndex = this.xssfCellStyle.getDataFormat();
            this.numFmtString = ObjectKit.defaultIfNull(this.xssfCellStyle.getDataFormatString(), () -> BuiltinFormats.getBuiltinFormat((int)numFmtIndex));
            if (CellDataType.NUMBER == this.cellDataType && ExcelSaxKit.isDateFormat(numFmtIndex, this.numFmtString)) {
                this.cellDataType = CellDataType.DATE;
            }
        }
    }
}

