/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.map.Dictionary;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.setting.magic.IniComment;
import org.aoju.bus.setting.magic.IniCommentImpl;
import org.aoju.bus.setting.magic.IniElement;
import org.aoju.bus.setting.magic.IniProperty;
import org.aoju.bus.setting.magic.IniPropertyImpl;
import org.aoju.bus.setting.magic.IniSection;
import org.aoju.bus.setting.magic.IniSectionImpl;
import org.aoju.bus.setting.magic.IniSetting;
import org.aoju.bus.setting.magic.PopSetting;
import org.aoju.bus.setting.magic.Properties;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Builder {
    private static final Map<String, Properties> CACHE_PROPS = new ConcurrentHashMap<String, Properties>();
    private static final Map<String, PopSetting> CACHE_SETTING = new ConcurrentHashMap<String, PopSetting>();
    private List<IniElement> elements;
    private LinkedList<Supplier<IniProperty>> waitForSections = new LinkedList();
    private IniSection lastSection;
    private int line = 1;
    private IniSectionCreator iniSectionCreator = IniSectionCreator.DEFAULT;
    private IniCommentCreator iniCommentCreator = IniCommentCreator.DEFAULT;
    private IniPropertyCreator iniPropertyCreator = IniPropertyCreator.DEFAULT;

    public Builder() {
        this.elements = new ArrayList<IniElement>();
    }

    public Builder(Supplier<List<IniElement>> listSupplier) {
        this.elements = listSupplier.get();
    }

    public static Properties getProperties(String name) {
        return CACHE_PROPS.computeIfAbsent(name, filePath -> {
            String suffix = FileKit.getSuffix((String)filePath);
            if (StringKit.isEmpty(suffix)) {
                filePath = (String)filePath + ".properties";
            }
            return new Properties((String)filePath);
        });
    }

    public static Dictionary load(String path) {
        return Builder.load(path, Dictionary.class);
    }

    public static <T> T load(String path, Class<T> type) {
        return Builder.load(FileKit.getStream(path), type);
    }

    public static <T> T load(InputStream in, Class<T> type) {
        return Builder.load(IoKit.getReader(in), type);
    }

    public static Dictionary load(Reader reader) {
        return Builder.load(reader, Dictionary.class);
    }

    public static <T> T load(Reader reader, Class<T> type) {
        return Builder.load(reader, type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(Reader reader, Class<T> type, boolean isCloseReader) {
        Assert.notNull(reader, "Reader must be not null !", new Object[0]);
        if (null == type) {
            type = Object.class;
        }
        Yaml yaml = new Yaml();
        try {
            Object object = yaml.loadAs(reader, type);
            return (T)object;
        }
        finally {
            if (isCloseReader) {
                IoKit.close(reader);
            }
        }
    }

    public static void parsePropsMap(Map<String, Object> result, String content) {
        String[] lines;
        for (String line : lines = content.split("\n")) {
            if (StringKit.isBlank(line) || line.startsWith("#") || line.indexOf("=") < 0) continue;
            String key = line.substring(0, line.indexOf("=")).trim();
            String value = line.substring(line.indexOf("=") + 1).trim();
            if (!StringKit.isNotBlank(value)) continue;
            result.put(key, value);
        }
    }

    public static void parseYamlMap(Map<String, Object> result, String content) {
        Yaml yaml = new Yaml();
        try {
            Map map = (Map)yaml.load(content);
            Builder.parseYamlMap(null, result, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void parseYamlMap(String prefix, Map<String, Object> result, Map<String, Object> content) {
        for (String key : content.keySet()) {
            String currentKey = prefix == null ? key.toString() : prefix + "." + key.toString();
            Object value = content.get(key);
            if (value instanceof Map) {
                Builder.parseYamlMap(currentKey, result, (Map)value);
                continue;
            }
            result.put(currentKey, value);
        }
    }

    public static String replaceRefValue(java.util.Properties properties, String value) {
        if (!value.contains("${")) {
            return value;
        }
        String[] segments = value.split("\\$\\{");
        StringBuilder finalValue = new StringBuilder();
        for (int i = 0; i < segments.length; ++i) {
            String seg = StringKit.trimToNull(segments[i]);
            if (StringKit.isBlank(seg)) continue;
            if (seg.contains("}")) {
                String refValue;
                String refKey = seg.substring(0, seg.indexOf("}")).trim();
                String withBraceString = null;
                if (seg.contains("{")) {
                    withBraceString = seg.substring(seg.indexOf("}") + 1);
                }
                String defaultValue = null;
                int defaultValSpliterIndex = refKey.indexOf(":");
                if (defaultValSpliterIndex > 0) {
                    defaultValue = refKey.substring(defaultValSpliterIndex + 1);
                    refKey = refKey.substring(0, defaultValSpliterIndex);
                }
                if (StringKit.isBlank(refValue = System.getProperty(refKey))) {
                    refValue = System.getenv(refKey);
                }
                if (StringKit.isBlank(refValue)) {
                    refValue = properties.getProperty(refKey);
                }
                if (StringKit.isBlank(refValue)) {
                    refValue = defaultValue;
                }
                if (StringKit.isBlank(refValue)) {
                    finalValue.append("${" + refKey + "}");
                } else {
                    finalValue.append(refValue);
                }
                if (withBraceString != null) {
                    finalValue.append(withBraceString);
                    continue;
                }
                String[] segments2 = seg.split("\\}");
                if (segments2.length != 2) continue;
                finalValue.append(segments2[1]);
                continue;
            }
            finalValue.append(seg);
        }
        return finalValue.toString();
    }

    public static void dump(Object object, Writer writer) {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Builder.dump(object, writer, options);
    }

    public static void dump(Object object, Writer writer, DumperOptions dumperOptions) {
        if (null == dumperOptions) {
            dumperOptions = new DumperOptions();
        }
        Yaml yaml = new Yaml(dumperOptions);
        yaml.dump(object, writer);
    }

    public Builder sectionCreator(IniSectionCreator iniSectionCreator) {
        Objects.requireNonNull(iniSectionCreator);
        this.iniSectionCreator = iniSectionCreator;
        return this;
    }

    public Builder commentCreator(IniCommentCreator iniCommentCreator) {
        Objects.requireNonNull(iniCommentCreator);
        this.iniCommentCreator = iniCommentCreator;
        return this;
    }

    public Builder propertyCreator(IniPropertyCreator iniPropertyCreator) {
        Objects.requireNonNull(iniPropertyCreator);
        this.iniPropertyCreator = iniPropertyCreator;
        return this;
    }

    public Builder skipLine(int length) {
        for (int i = 0; i < length; ++i) {
            this.elements.add(null);
            ++this.line;
        }
        return this;
    }

    public Builder plus(Builder otherBuilder) {
        this.elements.addAll(otherBuilder.elements);
        this.line += otherBuilder.line - 1;
        return this;
    }

    public Builder plus(List<IniElement> elements) {
        this.elements.addAll(elements);
        this.line += elements.size();
        return this;
    }

    public Builder plusSection(String value) {
        IniSection section = this.iniSectionCreator.create(value, this.line++, null);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    public Builder plusSection(String value, IniComment comment) {
        IniSection section = this.iniSectionCreator.create(value, this.line++, comment);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    public Builder plusSection(String value, String commentValue) {
        int lineNumber = this.line++;
        IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
        IniSection section = this.iniSectionCreator.create(value, lineNumber, comment);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    private void checkProps() {
        if (null != this.lastSection && !this.waitForSections.isEmpty()) {
            while (!this.waitForSections.isEmpty()) {
                IniProperty property = this.waitForSections.removeLast().get();
                property.setSection(this.lastSection);
                this.lastSection.add(property);
                this.elements.add(property);
            }
        }
    }

    private void checkProps(Supplier<IniProperty> propertySupplier) {
        if (null == this.lastSection) {
            this.waitForSections.addFirst(propertySupplier);
        } else {
            this.checkProps();
            IniProperty property = propertySupplier.get();
            property.setSection(this.lastSection);
            this.lastSection.add(property);
            this.elements.add(property);
        }
    }

    public Builder plusProperty(String key, String value) {
        this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, null));
        return this;
    }

    public Builder plusProperty(String key, String value, IniComment comment) {
        this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, comment));
        return this;
    }

    public Builder plusProperty(String key, String value, String commentValue) {
        this.checkProps(() -> {
            int lineNumber = this.line++;
            IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
            return this.iniPropertyCreator.create(key, value, lineNumber, comment);
        });
        return this;
    }

    public Builder plusProperties(java.util.Properties properties) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, null));
        }
        return this;
    }

    public Builder plusProperties(java.util.Properties properties, IniComment comment) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, comment));
        }
        return this;
    }

    public Builder plusProperties(java.util.Properties properties, String commentValue) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> {
                int lineNumber = this.line++;
                IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
                return this.iniPropertyCreator.create(key, value, lineNumber, comment);
            });
        }
        return this;
    }

    public Builder plusComment(String value) {
        IniComment comment = this.iniCommentCreator.create(value, this.line++);
        this.elements.add(comment);
        return this;
    }

    public IniSetting build() {
        return new IniSetting((Collection<? extends IniElement>)this.elements);
    }

    @FunctionalInterface
    public static interface IniSectionCreator {
        public static final IniSectionCreator DEFAULT = IniSectionImpl::new;

        public IniSection create(String var1, int var2, IniComment var3);
    }

    @FunctionalInterface
    public static interface IniCommentCreator {
        public static final IniCommentCreator DEFAULT = IniCommentImpl::byValue;

        public IniComment create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface IniPropertyCreator {
        public static final IniPropertyCreator DEFAULT = (k, v, l, c) -> new IniPropertyImpl(k, v, l);

        public IniProperty create(String var1, String var2, int var3, IniComment var4);
    }
}

