/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.aoju.bus.core.io.buffer.WriteBuffer;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.UdpChannel;

public class UdpAioSession
extends AioSession {
    private final UdpChannel udpChannel;
    private final SocketAddress remote;
    private final WriteBuffer writeBuffer;

    UdpAioSession(UdpChannel udpChannel, SocketAddress remote, WriteBuffer writeBuffer) {
        this.udpChannel = udpChannel;
        this.remote = remote;
        this.writeBuffer = writeBuffer;
        udpChannel.config.getProcessor().stateEvent(this, SocketStatus.NEW_SESSION, null);
    }

    @Override
    public WriteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    public ByteBuffer readBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void signalRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close(boolean immediate) {
        this.writeBuffer.close();
        this.udpChannel.config.getProcessor().stateEvent(this, SocketStatus.SESSION_CLOSED, null);
        this.udpChannel.removeSession(this.remote);
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        return (InetSocketAddress)this.udpChannel.getChannel().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.remote;
    }
}

