/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Resolver;
import org.aoju.bus.tracer.backend.TraceBackendProvider;

public class Tracer {
    public static Backend getBackend() {
        return Tracer.getBackend(new Resolver());
    }

    protected static Backend getBackend(Resolver resolver) {
        Set<TraceBackendProvider> backendProviders;
        try {
            backendProviders = resolver.getBackendProviders();
        }
        catch (RuntimeException e) {
            throw new InternalException("Unable to load available backend providers", e);
        }
        if (backendProviders.isEmpty()) {
            Set<TraceBackendProvider> defaultProvider = resolver.getDefaultTraceBackendProvider();
            if (defaultProvider.isEmpty()) {
                throw new InternalException("Unable to find a Builder backend provider. Make sure that you have Tracer(for slf4j) or any other backend implementation on the classpath.");
            }
            return defaultProvider.iterator().next().provideBackend();
        }
        if (backendProviders.size() > 1) {
            ArrayList providerClasses = new ArrayList(backendProviders.size());
            for (TraceBackendProvider backendProvider : backendProviders) {
                providerClasses.add(backendProvider.getClass());
            }
            String providerClassNames = Arrays.toString(providerClasses.toArray());
            throw new InternalException("Multiple Builder backend providers found. Don't know which one of the following to use: " + providerClassNames);
        }
        return backendProviders.iterator().next().provideBackend();
    }
}

