/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.base.advice;

import org.aoju.bus.base.advice.ErrorAdvice;
import org.aoju.bus.base.normal.ErrorCode;
import org.aoju.bus.base.spring.Controller;
import org.aoju.bus.core.exception.BusinessException;
import org.aoju.bus.core.exception.CrontabException;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.exception.ValidateException;
import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.toolkit.StringKit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@RestControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class BaseAdvice
extends Controller {
    @InitBinder
    public void initBinder(WebDataBinder binder) {
    }

    @ModelAttribute
    public void addAttributes(Model model) {
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Object defaultException(Exception e) {
        this.defaultExceptionHandler(e);
        return BaseAdvice.write(ErrorCode.EM_FAILURE);
    }

    @ResponseBody
    @ExceptionHandler(value={InternalException.class})
    public Object InternalException(InternalException e) {
        this.defaultExceptionHandler(e);
        if (StringKit.isBlank(e.getErrcode())) {
            return BaseAdvice.write(ErrorCode.EM_100510);
        }
        return BaseAdvice.write(e.getErrcode(), e.getErrmsg());
    }

    @ResponseBody
    @ExceptionHandler(value={BusinessException.class})
    public Object businessException(BusinessException e) {
        this.defaultExceptionHandler(e);
        if (StringKit.isBlank(e.getErrcode())) {
            return BaseAdvice.write(ErrorCode.EM_100513);
        }
        return BaseAdvice.write(e.getErrcode());
    }

    @ResponseBody
    @ExceptionHandler(value={CrontabException.class})
    public Object crontabException(CrontabException e) {
        this.defaultExceptionHandler(e);
        if (StringKit.isBlank(e.getErrcode())) {
            return BaseAdvice.write(ErrorCode.EM_100514);
        }
        return BaseAdvice.write(e.getErrcode(), e.getErrmsg());
    }

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public Object validateException(ValidateException e) {
        this.defaultExceptionHandler(e);
        if (StringKit.isBlank(e.getErrcode())) {
            return BaseAdvice.write(ErrorCode.EM_100510);
        }
        return BaseAdvice.write(e.getErrcode(), e.getErrmsg());
    }

    @ResponseBody
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Object httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        this.defaultExceptionHandler((Exception)e);
        return BaseAdvice.write(ErrorCode.EM_100507);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Object httpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        this.defaultExceptionHandler((Exception)e);
        return BaseAdvice.write(ErrorCode.EM_100508);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Object noHandlerFoundException(NoHandlerFoundException e) {
        this.defaultExceptionHandler((Exception)e);
        return BaseAdvice.write(ErrorCode.EM_100509);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class, BindException.class})
    public Object handleBodyValidException(MethodArgumentNotValidException e) {
        this.defaultExceptionHandler((Exception)e);
        return BaseAdvice.write(ErrorCode.EM_100511);
    }

    public void defaultExceptionHandler(Exception ex) {
        try {
            Instances.singletion(ErrorAdvice.class).handler(ex);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

