/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec.provider;

import org.aoju.bus.core.codec.Decoder;
import org.aoju.bus.core.codec.Encoder;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.StringKit;

public class Base16Provider
implements Encoder<byte[], char[]>,
Decoder<CharSequence, byte[]> {
    public static final Base16Provider CODEC_LOWER = new Base16Provider(true);
    public static final Base16Provider CODEC_UPPER = new Base16Provider(false);
    private final char[] alphabets;

    public Base16Provider(boolean lowerCase) {
        this.alphabets = lowerCase ? Normal.DIGITS_16_LOWER : Normal.DIGITS_16_UPPER;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            throw new InternalException("Illegal hexadecimal character {} at index {}", Character.valueOf(ch), index);
        }
        return digit;
    }

    @Override
    public char[] encode(byte[] data) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = this.hexDigit(data[i] >> 4);
            out[j++] = this.hexDigit(data[i]);
        }
        return out;
    }

    @Override
    public byte[] decode(CharSequence encoded) {
        if (StringKit.isEmpty((CharSequence)encoded)) {
            return null;
        }
        int len = (encoded = StringKit.cleanBlank((CharSequence)encoded)).length();
        if ((len & 1) != 0) {
            encoded = "0" + String.valueOf(encoded);
            len = encoded.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Base16Provider.toDigit(encoded.charAt(j), j) << 4;
            f |= Base16Provider.toDigit(encoded.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public String toUnicodeHex(char ch) {
        return "\\u" + this.hexDigit(ch >> 12) + this.hexDigit(ch >> 8) + this.hexDigit(ch >> 4) + this.hexDigit(ch);
    }

    public void appendHex(StringBuilder builder, byte b) {
        builder.append(this.hexDigit(b >> 4));
        builder.append(this.hexDigit(b));
    }

    public char hexDigit(int b) {
        return this.alphabets[b & 0xF];
    }
}

