/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compare;

import java.util.function.Function;
import org.aoju.bus.core.compare.NullCompare;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ObjectKit;

public class FuncCompare<T>
extends NullCompare<T> {
    private static final long serialVersionUID = 1L;
    private final Function<T, Comparable<?>> func;

    public FuncCompare(boolean nullGreater, Function<T, Comparable<?>> func) {
        super(nullGreater, null);
        this.func = func;
    }

    @Override
    protected int doCompare(T a, T b) {
        Comparable<?> v2;
        Comparable<?> v1;
        try {
            v1 = this.func.apply(a);
            v2 = this.func.apply(b);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
        return this.compare(a, b, v1, v2);
    }

    private int compare(T o1, T o2, Comparable v1, Comparable v2) {
        int result = ObjectKit.compare(v1, v2);
        if (0 == result) {
            result = ObjectKit.compare(o1, o2, this.nullGreater);
        }
        return result;
    }
}

