/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compare;

import java.util.Comparator;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ArrayKit;

public class IndexedCompare<T>
implements Comparator<T> {
    private final boolean atEndIfMiss;
    private final T[] array;

    public IndexedCompare(T ... object) {
        this(false, object);
    }

    public IndexedCompare(boolean atEndIfMiss, T ... object) {
        Assert.notNull(object, "'objs' array must not be null", new Object[0]);
        this.atEndIfMiss = atEndIfMiss;
        this.array = object;
    }

    @Override
    public int compare(T o1, T o2) {
        int index2;
        int index1 = this.getOrder(o1);
        if (index1 == (index2 = this.getOrder(o2)) && (index1 < 0 || index1 == this.array.length)) {
            return 1;
        }
        return Integer.compare(index1, index2);
    }

    private int getOrder(T object) {
        int order = ArrayKit.indexOf(this.array, object);
        if (order < 0) {
            order = this.atEndIfMiss ? this.array.length : -1;
        }
        return order;
    }
}

