/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NumberConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final NumberConverter INSTANCE = new NumberConverter();

    protected static Number convert(Object value, Class<? extends Number> targetType, Function<Object, String> func) {
        if (value instanceof Enum) {
            return NumberConverter.convert(((Enum)value).ordinal(), targetType, func);
        }
        if (value instanceof byte[]) {
            return ByteKit.getNumber((byte[])value, targetType);
        }
        if (Byte.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toByteObject((Boolean)value);
            }
            String valueStr = func.apply(value);
            try {
                return StringKit.isBlank(valueStr) ? null : Byte.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return MathKit.parseNumber(valueStr).byteValue();
            }
        }
        if (Short.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toShortObject((Boolean)value);
            }
            String valueStr = func.apply(value);
            try {
                return StringKit.isBlank(valueStr) ? null : Short.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return MathKit.parseNumber(valueStr).shortValue();
            }
        }
        if (Integer.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toInteger((Boolean)value);
            }
            if (value instanceof Date) {
                return (int)((Date)value).getTime();
            }
            if (value instanceof Calendar) {
                return (int)((Calendar)value).getTimeInMillis();
            }
            if (value instanceof TemporalAccessor) {
                return (int)DateKit.toInstant((TemporalAccessor)value).toEpochMilli();
            }
            String valueStr = func.apply(value);
            return StringKit.isBlank(valueStr) ? null : Integer.valueOf(MathKit.parseInt(valueStr));
        }
        if (AtomicInteger.class == targetType) {
            Number number = NumberConverter.convert(value, Integer.class, func);
            if (null != number) {
                return new AtomicInteger(number.intValue());
            }
        } else {
            if (Long.class == targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof Boolean) {
                    return BooleanKit.toLongObject((Boolean)value);
                }
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                if (value instanceof Calendar) {
                    return ((Calendar)value).getTimeInMillis();
                }
                if (value instanceof TemporalAccessor) {
                    return DateKit.toInstant((TemporalAccessor)value).toEpochMilli();
                }
                String valueStr = func.apply(value);
                return StringKit.isBlank(valueStr) ? null : Long.valueOf(MathKit.parseLong(valueStr));
            }
            if (AtomicLong.class == targetType) {
                Number number = NumberConverter.convert(value, Long.class, func);
                if (null != number) {
                    return new AtomicLong(number.longValue());
                }
            } else if (LongAdder.class == targetType) {
                Number number = NumberConverter.convert(value, Long.class, func);
                if (null != number) {
                    LongAdder longValue = new LongAdder();
                    longValue.add(number.longValue());
                    return longValue;
                }
            } else {
                if (Float.class == targetType) {
                    if (value instanceof Number) {
                        return Float.valueOf(((Number)value).floatValue());
                    }
                    if (value instanceof Boolean) {
                        return BooleanKit.toFloatObject((Boolean)value);
                    }
                    String valueStr = func.apply(value);
                    return StringKit.isBlank(valueStr) ? null : Float.valueOf(MathKit.parseFloat(valueStr));
                }
                if (Double.class == targetType) {
                    if (value instanceof Number) {
                        return MathKit.toDouble((Number)value);
                    }
                    if (value instanceof Boolean) {
                        return BooleanKit.toDoubleObject((Boolean)value);
                    }
                    String valueStr = func.apply(value);
                    return StringKit.isBlank(valueStr) ? null : Double.valueOf(MathKit.parseDouble(valueStr));
                }
                if (DoubleAdder.class == targetType) {
                    Number number = NumberConverter.convert(value, Double.class, func);
                    if (null != number) {
                        DoubleAdder doubleAdder = new DoubleAdder();
                        doubleAdder.add(number.doubleValue());
                        return doubleAdder;
                    }
                } else {
                    if (BigDecimal.class == targetType) {
                        return NumberConverter.toBigDecimal(value, func);
                    }
                    if (BigInteger.class == targetType) {
                        return NumberConverter.toBigInteger(value, func);
                    }
                    if (Number.class == targetType) {
                        if (value instanceof Number) {
                            return (Number)value;
                        }
                        if (value instanceof Boolean) {
                            return BooleanKit.toInteger((Boolean)value);
                        }
                        String result = func.apply(value);
                        return StringKit.isBlank(result) ? (Number)null : (Number)MathKit.parseNumber(result);
                    }
                }
            }
        }
        throw new UnsupportedOperationException(StringKit.format((CharSequence)"Unsupport Number type: {}", targetType.getName()));
    }

    private static BigDecimal toBigDecimal(Object value, Function<Object, String> func) {
        if (value instanceof Number) {
            return MathKit.toBigDecimal((Number)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return MathKit.toBigDecimal(func.apply(value));
    }

    private static BigInteger toBigInteger(Object value, Function<Object, String> func) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        return MathKit.toBigInteger(func.apply(value));
    }

    @Override
    protected Number convertInternal(Class<?> targetClass, Object value) {
        return NumberConverter.convert(value, targetClass, this::convertToString);
    }

    @Override
    protected String convertToString(Object value) {
        char c;
        String result = StringKit.trim(super.convertToString(value));
        if (null != result && result.length() > 1 && ((c = Character.toUpperCase(result.charAt(result.length() - 1))) == 'D' || c == 'L' || c == 'F')) {
            return StringKit.subPre(result, -1);
        }
        if (StringKit.isEmpty(result)) {
            throw new ConvertException("Can not convert empty value to Number!");
        }
        return result;
    }
}

