/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date.calendar;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import org.aoju.bus.core.date.Almanac;
import org.aoju.bus.core.date.Converter;
import org.aoju.bus.core.date.Formatter;
import org.aoju.bus.core.date.Holiday;
import org.aoju.bus.core.date.Lunar;
import org.aoju.bus.core.date.Solar;
import org.aoju.bus.core.toolkit.ObjectKit;

public class DayWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date date;
    private LocalDateTime localDateTime;
    private String dateStr;
    private int day;
    private int week;
    private String weekCnShort;
    private String weekCnLong;
    private String weekEnShort;
    private String weekEnShortUpper;
    private String weekEnLong;
    private String localHoliday;
    private Lunar lunar;
    private String chineseHoliday;
    private String lunarDateStr;
    private String lunarDay;
    private String solarTerm;
    private int dateType;
    private Object object;

    public DayWrapper(LocalDateTime localDateTime) {
        this(localDateTime, false);
    }

    public DayWrapper(LocalDateTime localDateTime, boolean includeLunarDate) {
        this(localDateTime, includeLunarDate, false);
    }

    public DayWrapper(LocalDateTime localDateTime, boolean includeLunarDate, boolean includeHoliday) {
        this(localDateTime, null, includeLunarDate, includeHoliday);
    }

    public DayWrapper(LocalDateTime localDateTime, Object object, boolean includeLunarDate, boolean includeHoliday) {
        this.localDateTime = localDateTime;
        this.date = Converter.toDate(localDateTime);
        this.dateStr = Formatter.format(localDateTime);
        this.day = localDateTime.getDayOfMonth();
        this.week = localDateTime.getDayOfWeek().getValue();
        this.weekCnShort = Almanac.getDayOfWeekCnShort(localDateTime);
        this.weekCnLong = Almanac.getDayOfWeekCn(localDateTime);
        this.weekEnShort = Almanac.getDayOfWeekEnShort(localDateTime);
        this.weekEnShortUpper = Almanac.getDayOfWeekEnShortUpper(localDateTime);
        this.weekEnLong = Almanac.getDayOfWeekEnLong(localDateTime);
        this.object = object;
        if (includeLunarDate) {
            this.lunar = new Solar(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth()).getLunar();
            this.lunarDateStr = this.lunar.toString();
            this.lunarDay = this.lunar.getDayInChinese();
            this.solarTerm = this.lunar.getSolarTerm();
        }
        if (includeHoliday) {
            Holiday holiday = Holiday.getHoliday(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth());
            this.localHoliday = ObjectKit.isNotNull(holiday) ? holiday.toString() : "";
            holiday = Holiday.getHoliday(localDateTime.getYear(), localDateTime.getMonthValue(), this.getDay());
            if (includeLunarDate) {
                this.chineseHoliday = ObjectKit.isNotNull(holiday) ? holiday.toString() : "";
            }
        }
        this.dateType = Almanac.isWorkDay(localDateTime) ? 1 : 0;
    }

    public Date getDate() {
        return this.date;
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }

    public String getDateStr() {
        return this.dateStr;
    }

    public int getDay() {
        return this.day;
    }

    public int getWeek() {
        return this.week;
    }

    public String getWeekCnShort() {
        return this.weekCnShort;
    }

    public String getWeekCnLong() {
        return this.weekCnLong;
    }

    public String getWeekEnShort() {
        return this.weekEnShort;
    }

    public String getWeekEnShortUpper() {
        return this.weekEnShortUpper;
    }

    public String getWeekEnLong() {
        return this.weekEnLong;
    }

    public String getLocalHoliday() {
        return this.localHoliday;
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public String getChineseHoliday() {
        return this.chineseHoliday;
    }

    public String getLunarDateStr() {
        return this.lunarDateStr;
    }

    public String getLunarDay() {
        return this.lunarDay;
    }

    public String getSolarTerm() {
        return this.solarTerm;
    }

    public int getDateType() {
        return this.dateType;
    }

    public Object getObject() {
        return this.object;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setLocalDateTime(LocalDateTime localDateTime) {
        this.localDateTime = localDateTime;
    }

    public void setDateStr(String dateStr) {
        this.dateStr = dateStr;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public void setWeekCnShort(String weekCnShort) {
        this.weekCnShort = weekCnShort;
    }

    public void setWeekCnLong(String weekCnLong) {
        this.weekCnLong = weekCnLong;
    }

    public void setWeekEnShort(String weekEnShort) {
        this.weekEnShort = weekEnShort;
    }

    public void setWeekEnShortUpper(String weekEnShortUpper) {
        this.weekEnShortUpper = weekEnShortUpper;
    }

    public void setWeekEnLong(String weekEnLong) {
        this.weekEnLong = weekEnLong;
    }

    public void setLocalHoliday(String localHoliday) {
        this.localHoliday = localHoliday;
    }

    public void setLunar(Lunar lunar) {
        this.lunar = lunar;
    }

    public void setChineseHoliday(String chineseHoliday) {
        this.chineseHoliday = chineseHoliday;
    }

    public void setLunarDateStr(String lunarDateStr) {
        this.lunarDateStr = lunarDateStr;
    }

    public void setLunarDay(String lunarDay) {
        this.lunarDay = lunarDay;
    }

    public void setSolarTerm(String solarTerm) {
        this.solarTerm = solarTerm;
    }

    public void setDateType(int dateType) {
        this.dateType = dateType;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DayWrapper)) {
            return false;
        }
        DayWrapper other = (DayWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getWeek() != other.getWeek()) {
            return false;
        }
        if (this.getDateType() != other.getDateType()) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        LocalDateTime this$localDateTime = this.getLocalDateTime();
        LocalDateTime other$localDateTime = other.getLocalDateTime();
        if (this$localDateTime == null ? other$localDateTime != null : !((Object)this$localDateTime).equals(other$localDateTime)) {
            return false;
        }
        String this$dateStr = this.getDateStr();
        String other$dateStr = other.getDateStr();
        if (this$dateStr == null ? other$dateStr != null : !this$dateStr.equals(other$dateStr)) {
            return false;
        }
        String this$weekCnShort = this.getWeekCnShort();
        String other$weekCnShort = other.getWeekCnShort();
        if (this$weekCnShort == null ? other$weekCnShort != null : !this$weekCnShort.equals(other$weekCnShort)) {
            return false;
        }
        String this$weekCnLong = this.getWeekCnLong();
        String other$weekCnLong = other.getWeekCnLong();
        if (this$weekCnLong == null ? other$weekCnLong != null : !this$weekCnLong.equals(other$weekCnLong)) {
            return false;
        }
        String this$weekEnShort = this.getWeekEnShort();
        String other$weekEnShort = other.getWeekEnShort();
        if (this$weekEnShort == null ? other$weekEnShort != null : !this$weekEnShort.equals(other$weekEnShort)) {
            return false;
        }
        String this$weekEnShortUpper = this.getWeekEnShortUpper();
        String other$weekEnShortUpper = other.getWeekEnShortUpper();
        if (this$weekEnShortUpper == null ? other$weekEnShortUpper != null : !this$weekEnShortUpper.equals(other$weekEnShortUpper)) {
            return false;
        }
        String this$weekEnLong = this.getWeekEnLong();
        String other$weekEnLong = other.getWeekEnLong();
        if (this$weekEnLong == null ? other$weekEnLong != null : !this$weekEnLong.equals(other$weekEnLong)) {
            return false;
        }
        String this$localHoliday = this.getLocalHoliday();
        String other$localHoliday = other.getLocalHoliday();
        if (this$localHoliday == null ? other$localHoliday != null : !this$localHoliday.equals(other$localHoliday)) {
            return false;
        }
        Lunar this$lunar = this.getLunar();
        Lunar other$lunar = other.getLunar();
        if (this$lunar == null ? other$lunar != null : !this$lunar.equals(other$lunar)) {
            return false;
        }
        String this$chineseHoliday = this.getChineseHoliday();
        String other$chineseHoliday = other.getChineseHoliday();
        if (this$chineseHoliday == null ? other$chineseHoliday != null : !this$chineseHoliday.equals(other$chineseHoliday)) {
            return false;
        }
        String this$lunarDateStr = this.getLunarDateStr();
        String other$lunarDateStr = other.getLunarDateStr();
        if (this$lunarDateStr == null ? other$lunarDateStr != null : !this$lunarDateStr.equals(other$lunarDateStr)) {
            return false;
        }
        String this$lunarDay = this.getLunarDay();
        String other$lunarDay = other.getLunarDay();
        if (this$lunarDay == null ? other$lunarDay != null : !this$lunarDay.equals(other$lunarDay)) {
            return false;
        }
        String this$solarTerm = this.getSolarTerm();
        String other$solarTerm = other.getSolarTerm();
        if (this$solarTerm == null ? other$solarTerm != null : !this$solarTerm.equals(other$solarTerm)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DayWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDay();
        result = result * 59 + this.getWeek();
        result = result * 59 + this.getDateType();
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        LocalDateTime $localDateTime = this.getLocalDateTime();
        result = result * 59 + ($localDateTime == null ? 43 : ((Object)$localDateTime).hashCode());
        String $dateStr = this.getDateStr();
        result = result * 59 + ($dateStr == null ? 43 : $dateStr.hashCode());
        String $weekCnShort = this.getWeekCnShort();
        result = result * 59 + ($weekCnShort == null ? 43 : $weekCnShort.hashCode());
        String $weekCnLong = this.getWeekCnLong();
        result = result * 59 + ($weekCnLong == null ? 43 : $weekCnLong.hashCode());
        String $weekEnShort = this.getWeekEnShort();
        result = result * 59 + ($weekEnShort == null ? 43 : $weekEnShort.hashCode());
        String $weekEnShortUpper = this.getWeekEnShortUpper();
        result = result * 59 + ($weekEnShortUpper == null ? 43 : $weekEnShortUpper.hashCode());
        String $weekEnLong = this.getWeekEnLong();
        result = result * 59 + ($weekEnLong == null ? 43 : $weekEnLong.hashCode());
        String $localHoliday = this.getLocalHoliday();
        result = result * 59 + ($localHoliday == null ? 43 : $localHoliday.hashCode());
        Lunar $lunar = this.getLunar();
        result = result * 59 + ($lunar == null ? 43 : $lunar.hashCode());
        String $chineseHoliday = this.getChineseHoliday();
        result = result * 59 + ($chineseHoliday == null ? 43 : $chineseHoliday.hashCode());
        String $lunarDateStr = this.getLunarDateStr();
        result = result * 59 + ($lunarDateStr == null ? 43 : $lunarDateStr.hashCode());
        String $lunarDay = this.getLunarDay();
        result = result * 59 + ($lunarDay == null ? 43 : $lunarDay.hashCode());
        String $solarTerm = this.getSolarTerm();
        result = result * 59 + ($solarTerm == null ? 43 : $solarTerm.hashCode());
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public String toString() {
        return "DayWrapper(date=" + String.valueOf(this.getDate()) + ", localDateTime=" + String.valueOf(this.getLocalDateTime()) + ", dateStr=" + this.getDateStr() + ", day=" + this.getDay() + ", week=" + this.getWeek() + ", weekCnShort=" + this.getWeekCnShort() + ", weekCnLong=" + this.getWeekCnLong() + ", weekEnShort=" + this.getWeekEnShort() + ", weekEnShortUpper=" + this.getWeekEnShortUpper() + ", weekEnLong=" + this.getWeekEnLong() + ", localHoliday=" + this.getLocalHoliday() + ", lunar=" + String.valueOf(this.getLunar()) + ", chineseHoliday=" + this.getChineseHoliday() + ", lunarDateStr=" + this.getLunarDateStr() + ", lunarDay=" + this.getLunarDay() + ", solarTerm=" + this.getSolarTerm() + ", dateType=" + this.getDateType() + ", object=" + String.valueOf(this.getObject()) + ")";
    }
}

