/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date.calendar;

import java.io.Serializable;
import java.util.List;
import org.aoju.bus.core.date.calendar.MonthWrapper;
import org.aoju.bus.core.toolkit.DateKit;

public class YearWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int year;
    private List<MonthWrapper> months;
    private boolean isLeapYear;
    private int length;

    public YearWrapper(int year, List<MonthWrapper> months) {
        this.year = year;
        this.months = months;
        this.isLeapYear = DateKit.isLeapYear(year);
        this.length = this.isLeapYear ? 366 : 365;
    }

    public int getYear() {
        return this.year;
    }

    public List<MonthWrapper> getMonths() {
        return this.months;
    }

    public boolean isLeapYear() {
        return this.isLeapYear;
    }

    public int getLength() {
        return this.length;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setMonths(List<MonthWrapper> months) {
        this.months = months;
    }

    public void setLeapYear(boolean isLeapYear) {
        this.isLeapYear = isLeapYear;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YearWrapper)) {
            return false;
        }
        YearWrapper other = (YearWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getYear() != other.getYear()) {
            return false;
        }
        if (this.isLeapYear() != other.isLeapYear()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        List<MonthWrapper> this$months = this.getMonths();
        List<MonthWrapper> other$months = other.getMonths();
        return !(this$months == null ? other$months != null : !((Object)this$months).equals(other$months));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YearWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getYear();
        result = result * 59 + (this.isLeapYear() ? 79 : 97);
        result = result * 59 + this.getLength();
        List<MonthWrapper> $months = this.getMonths();
        result = result * 59 + ($months == null ? 43 : ((Object)$months).hashCode());
        return result;
    }

    public String toString() {
        return "YearWrapper(year=" + this.getYear() + ", months=" + String.valueOf(this.getMonths()) + ", isLeapYear=" + this.isLeapYear() + ", length=" + this.getLength() + ")";
    }
}

