/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.instance;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.instance.Instance;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ObjectKit;

public final class InstanceFactory
implements Instance {
    private final Map<String, Object> singletonMap = new ConcurrentHashMap<String, Object>();
    private final ThreadLocal<Map<String, Object>> mapThreadLocal = new ThreadLocal();

    private InstanceFactory() {
    }

    public static InstanceFactory getInstance() {
        return SingletonHolder.INSTANCE_FACTORY;
    }

    public static <T> T singletion(Class<T> clazz) {
        return InstanceFactory.getInstance().singleton(clazz);
    }

    public static <T> T singletion(Class<T> clazz, String groupName) {
        return InstanceFactory.getInstance().singleton(clazz, groupName);
    }

    @Override
    public <T> T singleton(Class<T> clazz, String groupName) {
        return this.getSingleton(clazz, groupName, this.singletonMap);
    }

    @Override
    public <T> T singleton(Class<T> clazz) {
        this.notNull(clazz);
        return this.getSingleton(clazz, this.singletonMap);
    }

    @Override
    public <T> T threadLocal(Class<T> clazz) {
        this.notNull(clazz);
        Map<String, Object> map = this.mapThreadLocal.get();
        if (ObjectKit.isNull(map)) {
            map = new ConcurrentHashMap<String, Object>();
        }
        T instance = this.getSingleton(clazz, map);
        this.mapThreadLocal.set(map);
        return instance;
    }

    @Override
    public <T> T multiple(Class<T> clazz) {
        this.notNull(clazz);
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public <T> T threadSafe(Class<T> clazz) {
        if (clazz.isAnnotationPresent(ThreadSafe.class)) {
            return this.singleton(clazz);
        }
        return this.multiple(clazz);
    }

    private <T> T getSingleton(Class<T> clazz, Map<String, Object> instanceMap) {
        this.notNull(clazz);
        String fullClassName = clazz.getName();
        Object instance = instanceMap.get(fullClassName);
        if (ObjectKit.isNull(instance)) {
            instance = this.multiple(clazz);
            instanceMap.put(fullClassName, instance);
        }
        return (T)instance;
    }

    private <T> T getSingleton(Class<T> clazz, String group, Map<String, Object> instanceMap) {
        this.notNull(clazz);
        Assert.notEmpty(group, "key", new Object[0]);
        String fullClassName = clazz.getName() + "-" + group;
        Object instance = instanceMap.get(fullClassName);
        if (ObjectKit.isNull(instance)) {
            instance = this.multiple(clazz);
            instanceMap.put(fullClassName, instance);
        }
        return (T)instance;
    }

    private void notNull(Class clazz) {
        Assert.notNull(clazz, "class", new Object[0]);
    }

    private static class SingletonHolder {
        private static final InstanceFactory INSTANCE_FACTORY = new InstanceFactory();

        private SingletonHolder() {
        }
    }
}

