/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.toolkit.StringKit;

public class BytesResource
implements Resource {
    private final byte[] bytes;
    private final String name;

    public BytesResource(byte[] bytes) {
        this(bytes, null);
    }

    public BytesResource(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public String readString(Charset charset) throws InternalException {
        return StringKit.toString(this.bytes, charset);
    }

    @Override
    public byte[] readBytes() throws InternalException {
        return this.bytes;
    }
}

