/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.stream;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.reader.ReaderWrapper;
import org.aoju.bus.core.io.stream.BOMInputStream;
import org.aoju.bus.core.lang.Assert;

public class BOMReader
extends ReaderWrapper {
    public BOMReader(InputStream in) {
        super(BOMReader.initReader(in));
    }

    private static InputStreamReader initReader(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        BOMInputStream bin = in instanceof BOMInputStream ? (BOMInputStream)in : new BOMInputStream(in);
        try {
            return new InputStreamReader((InputStream)bin, bin.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException(e);
        }
    }
}

