/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.buffer.FastByteBuffer;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ObjectKit;

public class FastByteOutputStream
extends OutputStream {
    private final FastByteBuffer buffer;

    public FastByteOutputStream() {
        this(1024);
    }

    public FastByteOutputStream(int size) {
        this.buffer = new FastByteBuffer(size);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.append(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.append((byte)b);
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.buffer.reset();
    }

    public void writeTo(OutputStream out) throws InternalException {
        int index = this.buffer.index();
        if (index < 0) {
            return;
        }
        try {
            for (int i = 0; i < index; ++i) {
                byte[] buf = this.buffer.array(i);
                out.write(buf);
            }
            out.write(this.buffer.array(index), 0, this.buffer.offset());
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public String toString() {
        return this.toString(Charset.defaultCharset());
    }

    public String toString(java.nio.charset.Charset charset) {
        return new String(this.toByteArray(), ObjectKit.defaultIfNull(charset, java.nio.charset.Charset::defaultCharset));
    }
}

