/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.stream;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.Progress;
import org.aoju.bus.core.io.stream.FastByteOutputStream;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public class SyncInputStream
extends FilterInputStream {
    private final long length;
    private final boolean isIgnoreEOFError;
    private volatile boolean asyncFlag = true;

    public SyncInputStream(InputStream in, long length, boolean isAsync, boolean isIgnoreEOFError) {
        super(in);
        this.length = length;
        this.isIgnoreEOFError = isIgnoreEOFError;
        if (!isAsync) {
            this.sync();
        }
    }

    private static boolean isEOFException(Throwable e) {
        if (e instanceof FileNotFoundException) {
            return true;
        }
        return e instanceof EOFException || StringKit.containsIgnoreCase(e.getMessage(), "Premature EOF");
    }

    public void sync() {
        if (!this.asyncFlag) {
            return;
        }
        this.in = new ByteArrayInputStream(this.readBytes());
        this.asyncFlag = false;
    }

    public byte[] readBytes() {
        FastByteOutputStream bytesOut = new FastByteOutputStream(this.length > 0L ? (int)this.length : 1024);
        long length = this.copyTo(bytesOut, null);
        return length > 0L ? bytesOut.toByteArray() : new byte[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyTo(OutputStream out, Progress streamProgress) {
        long copyLength = -1L;
        try {
            copyLength = IoKit.copy(this.in, out, 8192, this.length, streamProgress);
        }
        catch (InternalException e) {
            if (!(this.isIgnoreEOFError && SyncInputStream.isEOFException(e.getCause()))) {
                throw e;
            }
        }
        finally {
            IoKit.close(this.in);
        }
        return copyLength;
    }
}

