/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.function;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Optional;
import org.aoju.bus.core.lang.mutable.MutableEntry;
import org.aoju.bus.core.lang.reflect.LookupFactory;
import org.aoju.bus.core.map.WeakMap;
import org.aoju.bus.core.toolkit.ReflectKit;

public class LambdaFactory {
    private static final Map<MutableEntry<Class<?>, Method>, Object> CACHE = new WeakMap();

    private LambdaFactory() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public static <F> F build(Class<F> functionInterfaceType, Class<?> methodClass, String methodName, Class<?> ... paramTypes) {
        return LambdaFactory.build(functionInterfaceType, ReflectKit.getMethod(methodClass, methodName, paramTypes));
    }

    public static <F> F build(Class<F> functionInterfaceType, Method method) {
        Assert.notNull(functionInterfaceType);
        Assert.notNull(method);
        MutableEntry<Class<F>, Method> cacheKey = new MutableEntry<Class<F>, Method>(functionInterfaceType, method);
        return (F)CACHE.computeIfAbsent(cacheKey, key -> {
            List abstractMethods = Arrays.stream(functionInterfaceType.getMethods()).filter(m -> Modifier.isAbstract(m.getModifiers())).collect(Collectors.toList());
            Assert.equals(abstractMethods.size(), 1, "\u4e0d\u652f\u6301\u975e\u51fd\u6570\u5f0f\u63a5\u53e3", new Object[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Method invokeMethod = (Method)abstractMethods.get(0);
            MethodHandles.Lookup caller = LookupFactory.lookup(method.getDeclaringClass());
            String invokeName = invokeMethod.getName();
            MethodType invokedType = MethodType.methodType(functionInterfaceType);
            MethodType samMethodType = MethodType.methodType(invokeMethod.getReturnType(), invokeMethod.getParameterTypes());
            MethodHandle implMethod = Optional.ofTry(() -> caller.unreflect(method)).get();
            MethodType insMethodType = MethodType.methodType(method.getReturnType(), method.getDeclaringClass(), method.getParameterTypes());
            boolean isSerializable = Serializable.class.isAssignableFrom(functionInterfaceType);
            try {
                CallSite callSite = isSerializable ? LambdaMetafactory.altMetafactory(caller, invokeName, invokedType, samMethodType, implMethod, insMethodType, 1) : LambdaMetafactory.metafactory(caller, invokeName, invokedType, samMethodType, implMethod, insMethodType);
                return callSite.getTarget().invoke();
            }
            catch (Throwable e) {
                throw new InternalException(e);
            }
        });
    }
}

