/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.mutable;

import org.aoju.bus.core.lang.mutable.Mutable;
import org.aoju.bus.core.toolkit.MathKit;

public class MutableByte
extends Number
implements Comparable<MutableByte>,
Mutable<Number> {
    private static final long serialVersionUID = 1L;
    private byte value;

    public MutableByte() {
    }

    public MutableByte(byte value) {
        this.value = value;
    }

    public MutableByte(Number value) {
        this(value.byteValue());
    }

    public MutableByte(String value) throws NumberFormatException {
        this.value = Byte.parseByte(value);
    }

    @Override
    public Byte get() {
        return this.value;
    }

    @Override
    public void set(byte value) {
        this.value = value;
    }

    @Override
    public void set(Number value) {
        this.value = value.byteValue();
    }

    public MutableByte increment() {
        this.value = (byte)(this.value + 1);
        return this;
    }

    public MutableByte decrement() {
        this.value = (byte)(this.value - 1);
        return this;
    }

    public MutableByte add(byte operand) {
        this.value = (byte)(this.value + operand);
        return this;
    }

    public MutableByte add(Number operand) {
        this.value = (byte)(this.value + operand.byteValue());
        return this;
    }

    public MutableByte subtract(byte operand) {
        this.value = (byte)(this.value - operand);
        return this;
    }

    public MutableByte subtract(Number operand) {
        this.value = (byte)(this.value - operand.byteValue());
        return this;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof MutableByte) {
            return this.value == ((MutableByte)object).byteValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(MutableByte other) {
        return MathKit.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

