/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.aoju.bus.core.map.FuncKeyMap;
import org.aoju.bus.core.map.MapBuilder;
import org.aoju.bus.core.toolkit.StringKit;

public class CamelCaseMap<K, V>
extends FuncKeyMap<K, V> {
    private static final long serialVersionUID = 1L;

    public CamelCaseMap() {
        this(16);
    }

    public CamelCaseMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseMap(Map<? extends K, ? extends V> m) {
        this(0.75f, m);
    }

    public CamelCaseMap(float loadFactor, Map<? extends K, ? extends V> map) {
        this(map.size(), loadFactor);
        this.putAll(map);
    }

    public CamelCaseMap(int initialCapacity, float loadFactor) {
        this(MapBuilder.of(new HashMap(initialCapacity, loadFactor)));
    }

    CamelCaseMap(MapBuilder<K, V> emptyMapBuilder) {
        super(emptyMapBuilder.build(), (Function<Object, Object> & Serializable)key -> {
            if (key instanceof CharSequence) {
                key = StringKit.toCamelCase(key.toString());
            }
            return key;
        });
    }
}

