/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.util.Map;
import java.util.function.Supplier;
import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.toolkit.MapKit;

public class MapBuilder<K, V>
implements Builder<Map<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> map;

    public MapBuilder(Map<K, V> map) {
        this.map = map;
    }

    public static <K, V> MapBuilder<K, V> of() {
        return MapBuilder.of(false);
    }

    public static <K, V> MapBuilder<K, V> of(boolean isLinked) {
        return MapBuilder.of(MapKit.newHashMap(isLinked));
    }

    public static <K, V> MapBuilder<K, V> of(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public MapBuilder<K, V> put(K k, V v) {
        this.map.put(k, v);
        return this;
    }

    public MapBuilder<K, V> put(boolean condition, K k, V v) {
        if (condition) {
            this.put(k, v);
        }
        return this;
    }

    public MapBuilder<K, V> put(boolean condition, K k, Supplier<V> supplier) {
        if (condition) {
            this.put(k, supplier.get());
        }
        return this;
    }

    public MapBuilder<K, V> putAll(Map<K, V> map) {
        this.map.putAll(map);
        return this;
    }

    public MapBuilder<K, V> clear() {
        this.map.clear();
        return this;
    }

    public Map<K, V> map() {
        return this.map;
    }

    @Override
    public Map<K, V> build() {
        return this.map();
    }

    public String join(String separator, String keyValueSeparator) {
        return MapKit.join(this.map, separator, keyValueSeparator, new String[0]);
    }

    public String joinIgnoreNull(String separator, String keyValueSeparator) {
        return MapKit.joinIgnoreNull(this.map, separator, keyValueSeparator, new String[0]);
    }

    public String join(String separator, String keyValueSeparator, boolean isIgnoreNull) {
        return MapKit.join(this.map, separator, keyValueSeparator, isIgnoreNull, new String[0]);
    }
}

