/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Typed;
import org.aoju.bus.core.lang.reflect.ActualTypeMapper;
import org.aoju.bus.core.map.TableMap;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;

public class TypeKit {
    private static final Class[] BASE_TYPE_CLASS = new Class[]{String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class, Object.class, Class.class};

    public static boolean isMap(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isIterable(Class<?> clazz) {
        return Iterable.class.isAssignableFrom(clazz);
    }

    public static boolean isBase(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        for (Class baseClazz : BASE_TYPE_CLASS) {
            if (!baseClazz.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstractOrInterface(Class<?> clazz) {
        return TypeKit.isAbstract(clazz) || clazz.isInterface();
    }

    public static boolean isJavaBean(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !TypeKit.isAbstract(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive() && !TypeKit.isIterable(clazz) && !TypeKit.isMap(clazz);
    }

    public static boolean isJdk(Class<?> clazz) {
        return null != clazz && null == clazz.getClassLoader();
    }

    public static boolean isAssignable(Type type, Type toType) {
        return TypeKit.isAssignable(type, toType, null);
    }

    private static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (null == toType || toType instanceof Class) {
            return TypeKit.isAssignable(type, (Class)toType);
        }
        if (toType instanceof ParameterizedType) {
            return TypeKit.isAssignable(type, (ParameterizedType)toType, typeVarAssigns);
        }
        if (toType instanceof GenericArrayType) {
            return TypeKit.isAssignable(type, (GenericArrayType)toType, typeVarAssigns);
        }
        if (toType instanceof WildcardType) {
            return TypeKit.isAssignable(type, (WildcardType)toType, typeVarAssigns);
        }
        if (toType instanceof TypeVariable) {
            return TypeKit.isAssignable(type, (TypeVariable)toType, typeVarAssigns);
        }
        throw new IllegalStateException("found an unhandled type: " + String.valueOf(toType));
    }

    private static boolean isAssignable(Type type, Class<?> toClass) {
        if (null == type) {
            return null == toClass || !toClass.isPrimitive();
        }
        if (null == toClass) {
            return false;
        }
        if (toClass.equals(type)) {
            return true;
        }
        if (type instanceof Class) {
            return ClassKit.isAssignable((Class)type, toClass);
        }
        if (type instanceof ParameterizedType) {
            return TypeKit.isAssignable(TypeKit.getRawType((ParameterizedType)type), toClass);
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                if (!TypeKit.isAssignable(bound, toClass)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            return toClass.equals(Object.class) || toClass.isArray() && TypeKit.isAssignable(((GenericArrayType)type).getGenericComponentType(), toClass.getComponentType());
        }
        if (type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + String.valueOf(type));
    }

    private static boolean isAssignable(Type type, ParameterizedType toParameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (null == type) {
            return true;
        }
        if (null == toParameterizedType) {
            return false;
        }
        if (toParameterizedType.equals(type)) {
            return true;
        }
        Class<?> toClass = TypeKit.getRawType(toParameterizedType);
        Map<TypeVariable<?>, Type> fromTypeVarAssigns = TypeKit.getTypeArguments(type, toClass, null);
        if (null == fromTypeVarAssigns) {
            return false;
        }
        if (fromTypeVarAssigns.isEmpty()) {
            return true;
        }
        Map<TypeVariable<?>, Type> toTypeVarAssigns = TypeKit.getTypeArguments(toParameterizedType, toClass, typeVarAssigns);
        for (TypeVariable<?> var : toTypeVarAssigns.keySet()) {
            Type toTypeArg = TypeKit.unrollVariableAssignments(var, toTypeVarAssigns);
            Type fromTypeArg = TypeKit.unrollVariableAssignments(var, fromTypeVarAssigns);
            if (null == toTypeArg && fromTypeArg instanceof Class || null == fromTypeArg || toTypeArg.equals(fromTypeArg) || toTypeArg instanceof WildcardType && TypeKit.isAssignable(fromTypeArg, toTypeArg, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayType(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    public static boolean isUnknown(Type type) {
        return null == type || type instanceof TypeVariable;
    }

    public static Class<?> getClass(Type type) {
        if (null != type) {
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                return (Class)((TypeVariable)type).getBounds()[0];
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return TypeKit.getClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static Class<?> getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        return field.getGenericType();
    }

    public static Type getFieldType(Class<?> clazz, String fieldName) {
        return TypeKit.getType(ReflectKit.getField(clazz, fieldName));
    }

    public static Type getFirstParamType(Method method) {
        return TypeKit.getParamType(method, 0);
    }

    public static Class<?> getFirstParamClass(Method method) {
        return TypeKit.getParamClass(method, 0);
    }

    public static Type getParamType(Method method, int index) {
        Type[] types = TypeKit.getParamTypes(method);
        if (null != types && types.length > index) {
            return types[index];
        }
        return null;
    }

    public static Class<?> getParamClass(Method method, int index) {
        Class<?>[] classes = TypeKit.getParamClasses(method);
        if (null != classes && classes.length > index) {
            return classes[index];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Type type) {
        return TypeKit.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = TypeKit.getTypeArguments(type);
        if (null != typeArguments && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType parameterizedType = TypeKit.toParameterizedType(type);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType type) {
        return TypeKit.getTypeArguments(type, TypeKit.getRawType(type), null);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
        return TypeKit.getTypeArguments(type, toClass, null);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        if (type instanceof Class) {
            return TypeKit.getTypeArguments((Class)type, toClass, subtypeVarAssigns);
        }
        if (type instanceof ParameterizedType) {
            return TypeKit.getTypeArguments((ParameterizedType)type, toClass, subtypeVarAssigns);
        }
        if (type instanceof GenericArrayType) {
            return TypeKit.getTypeArguments(((GenericArrayType)type).getGenericComponentType(), toClass.isArray() ? toClass.getComponentType() : toClass, subtypeVarAssigns);
        }
        if (type instanceof WildcardType) {
            for (Type bound : TypeKit.getImplicitUpperBounds((WildcardType)type)) {
                if (!TypeKit.isAssignable(bound, toClass)) continue;
                return TypeKit.getTypeArguments(bound, toClass, subtypeVarAssigns);
            }
            return null;
        }
        if (type instanceof TypeVariable) {
            for (Type bound : TypeKit.getImplicitBounds((TypeVariable)type)) {
                if (!TypeKit.isAssignable(bound, toClass)) continue;
                return TypeKit.getTypeArguments(bound, toClass, subtypeVarAssigns);
            }
            return null;
        }
        throw new IllegalStateException("found an unhandled type: " + String.valueOf(type));
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> cls, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        HashMap typeVarAssigns;
        if (!TypeKit.isAssignable(cls, toClass)) {
            return null;
        }
        if (cls.isPrimitive()) {
            if (toClass.isPrimitive()) {
                return new HashMap();
            }
            cls = ClassKit.primitiveToWrapper(cls);
        }
        HashMap hashMap = typeVarAssigns = null == subtypeVarAssigns ? new HashMap() : new HashMap(subtypeVarAssigns);
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return TypeKit.getTypeArguments(TypeKit.getClosestParentType(cls, toClass), toClass, typeVarAssigns);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        HashMap<TypeVariable<?>, Type> typeVarAssigns;
        Class<?> cls = TypeKit.getRawType(parameterizedType);
        if (!TypeKit.isAssignable(cls, toClass)) {
            return null;
        }
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            ParameterizedType parameterizedOwnerType = (ParameterizedType)ownerType;
            typeVarAssigns = TypeKit.getTypeArguments(parameterizedOwnerType, TypeKit.getRawType(parameterizedOwnerType), subtypeVarAssigns);
        } else {
            typeVarAssigns = null == subtypeVarAssigns ? new HashMap() : new HashMap(subtypeVarAssigns);
        }
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeParams = cls.getTypeParameters();
        for (int i = 0; i < typeParams.length; ++i) {
            Type typeArg = typeArgs[i];
            typeVarAssigns.put(typeParams[i], typeVarAssigns.containsKey(typeArg) ? (Type)typeVarAssigns.get(typeArg) : typeArg);
        }
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return TypeKit.getTypeArguments(TypeKit.getClosestParentType(cls, toClass), toClass, typeVarAssigns);
    }

    public static Type getClosestParentType(Class<?> cls, Class<?> superClass) {
        if (superClass.isInterface()) {
            Type[] interfaceTypes = cls.getGenericInterfaces();
            Type genericInterface = null;
            for (Type midType : interfaceTypes) {
                Class midClass;
                if (midType instanceof ParameterizedType) {
                    midClass = TypeKit.getRawType((ParameterizedType)midType);
                } else if (midType instanceof Class) {
                    midClass = (Class)midType;
                } else {
                    throw new IllegalStateException("Unexpected generic interface type found: " + String.valueOf(midType));
                }
                if (!TypeKit.isAssignable((Type)midClass, superClass) || !TypeKit.isAssignable(genericInterface, (Type)midClass)) continue;
                genericInterface = midType;
            }
            if (null != genericInterface) {
                return genericInterface;
            }
        }
        return cls.getGenericSuperclass();
    }

    public static Type[] getActualTypes(Type actualType, Class<?> typeDefineClass, Type ... typeVariables) {
        if (!typeDefineClass.isAssignableFrom(TypeKit.getClass(actualType))) {
            throw new IllegalArgumentException("Parameter [superClass] must be assignable from [clazz]");
        }
        TypeVariable<Class<?>>[] typeVars = typeDefineClass.getTypeParameters();
        if (ArrayKit.isEmpty(typeVars)) {
            return null;
        }
        Type[] actualTypeArguments = TypeKit.getTypeArguments(actualType);
        if (ArrayKit.isEmpty(actualTypeArguments)) {
            return null;
        }
        int size = Math.min(actualTypeArguments.length, typeVars.length);
        TableMap tableMap = new TableMap(typeVars, actualTypeArguments);
        Type[] result = new Type[size];
        for (int i = 0; i < typeVariables.length; ++i) {
            result[i] = typeVariables[i] instanceof TypeVariable ? (Type)tableMap.get(typeVariables[i]) : typeVariables[i];
        }
        return result;
    }

    public static Type getActualType(Type actualType, Class<?> typeDefineClass, Type typeVariable) {
        Type[] types = TypeKit.getActualTypes(actualType, typeDefineClass, typeVariable);
        if (ArrayKit.isNotEmpty(types)) {
            return types[0];
        }
        return null;
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && ArrayKit.isNotEmpty(genericInterfaces = clazz.getGenericInterfaces())) {
                genericSuper = genericInterfaces[0];
            }
            result = TypeKit.toParameterizedType(genericSuper);
        }
        return result;
    }

    public static Map<Type, Type> getTypeMap(Class<?> clazz) {
        return ActualTypeMapper.get(clazz);
    }

    public static Type getActualType(Type type, Field field) {
        if (null == field) {
            return null;
        }
        return TypeKit.getActualType((Type)ObjectKit.defaultIfNull(type, field.getDeclaringClass()), field.getGenericType());
    }

    public static Type getActualType(Type type, Type typeVariable) {
        if (typeVariable instanceof ParameterizedType) {
            return TypeKit.getActualType(type, (ParameterizedType)typeVariable);
        }
        if (typeVariable instanceof TypeVariable) {
            return ActualTypeMapper.getActualType(type, (TypeVariable)typeVariable);
        }
        return typeVariable;
    }

    public static Type getActualType(Type type, ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (TypeKit.hasTypeVariable(actualTypeArguments) && ArrayKit.isNotEmpty(actualTypeArguments = TypeKit.getActualTypes(type, parameterizedType.getActualTypeArguments()))) {
            parameterizedType = new Typed(actualTypeArguments, parameterizedType.getOwnerType(), parameterizedType.getRawType());
        }
        return parameterizedType;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        return ActualTypeMapper.getActualTypes(type, typeVariables);
    }

    private static Class<?> getRawType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new IllegalStateException("Wait... What!? Type of rawType: " + String.valueOf(rawType));
        }
        return (Class)rawType;
    }

    public static Class<?> getRawType(Type type, Type assigningType) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeKit.getRawType((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            if (null == assigningType) {
                return null;
            }
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (!(genericDeclaration instanceof Class)) {
                return null;
            }
            Map<TypeVariable<?>, Type> typeVarAssigns = TypeKit.getTypeArguments(assigningType, (Class)genericDeclaration);
            if (null == typeVarAssigns) {
                return null;
            }
            Type typeArgument = typeVarAssigns.get(type);
            if (null == typeArgument) {
                return null;
            }
            return TypeKit.getRawType(typeArgument, assigningType);
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = TypeKit.getRawType(((GenericArrayType)type).getGenericComponentType(), assigningType);
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        if (type instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + String.valueOf(type));
    }

    public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
        Type[] typeArray;
        Assert.notNull(typeVariable, "typeVariable is null", new Object[0]);
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = TypeKit.normalizeUpperBounds(bounds);
        }
        return typeArray;
    }

    public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Assert.notNull(wildcardType, "wildcardType is null", new Object[0]);
        Type[] bounds = wildcardType.getUpperBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = TypeKit.normalizeUpperBounds(bounds);
        }
        return typeArray;
    }

    public static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Assert.notNull(wildcardType, "wildcardType is null", new Object[0]);
        Type[] bounds = wildcardType.getLowerBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = null;
        } else {
            typeArray = bounds;
        }
        return typeArray;
    }

    public static Type[] normalizeUpperBounds(Type[] bounds) {
        Assert.notNull(bounds, "null value specified for bounds array", new Object[0]);
        if (bounds.length < 2) {
            return bounds;
        }
        HashSet<Type> types = new HashSet<Type>(bounds.length);
        for (Type type1 : bounds) {
            boolean subtypeFound = false;
            for (Type type2 : bounds) {
                if (type1 == type2 || !TypeKit.isAssignable(type2, type1, null)) continue;
                subtypeFound = true;
                break;
            }
            if (subtypeFound) continue;
            types.add(type1);
        }
        return types.toArray(new Type[types.size()]);
    }

    public static boolean hasTypeVariable(Type ... types) {
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }

    private static Type unrollVariableAssignments(TypeVariable<?> var, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type result;
        while ((result = typeVarAssigns.get(var)) instanceof TypeVariable && !result.equals(var)) {
            var = (TypeVariable)result;
        }
        return result;
    }
}

