/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.aoju.bus.core.date.Almanac;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.cron.pattern.matcher.PatternMatcher;
import org.aoju.bus.cron.pattern.parser.PatternParser;

public class CronPattern {
    private final String pattern;
    private final List<PatternMatcher> matchers;

    public CronPattern(String pattern) {
        this.pattern = pattern;
        this.matchers = PatternParser.parse(pattern);
    }

    public static CronPattern of(String pattern) {
        return new CronPattern(pattern);
    }

    private static int[] getFields(Calendar calendar, boolean isMatchSecond) {
        int second = isMatchSecond ? calendar.get(13) : -1;
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        int dayOfMonth = calendar.get(5);
        int month = calendar.get(2) + 1;
        int dayOfWeek = calendar.get(7) - 1;
        int year = calendar.get(1);
        return new int[]{second, minute, hour, dayOfMonth, month, dayOfWeek, year};
    }

    static int[] getFields(LocalDateTime dateTime, boolean isMatchSecond) {
        int second = isMatchSecond ? dateTime.getSecond() : -1;
        int minute = dateTime.getMinute();
        int hour = dateTime.getHour();
        int dayOfMonth = dateTime.getDayOfMonth();
        int month = dateTime.getMonthValue();
        int dayOfWeek = Fields.Week.getByCode(dateTime.getDayOfWeek().getValue()).getKey() - 1;
        int year = dateTime.getYear();
        return new int[]{second, minute, hour, dayOfMonth, month, dayOfWeek, year};
    }

    public static Date nextDateAfter(CronPattern pattern, Date start, boolean isMatchSecond) {
        List<Date> matchedDates = CronPattern.matchedDates(pattern, start.getTime(), DateKit.endOfYear(start).getTime(), 1, isMatchSecond);
        if (CollKit.isNotEmpty(matchedDates)) {
            return matchedDates.get(0);
        }
        return null;
    }

    public static List<Date> matchedDates(String patternStr, Date start, int count, boolean isMatchSecond) {
        return CronPattern.matchedDates(patternStr, start, DateKit.endOfYear(start), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, Date start, Date end, int count, boolean isMatchSecond) {
        return CronPattern.matchedDates(patternStr, start.getTime(), end.getTime(), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, long start, long end, int count, boolean isMatchSecond) {
        return CronPattern.matchedDates(new CronPattern(patternStr), start, end, count, isMatchSecond);
    }

    public static List<Date> matchedDates(CronPattern pattern, long start, long end, int count, boolean isMatchSecond) {
        Assert.isTrue(start < end, "Start date is later than end !", new Object[0]);
        ArrayList<Date> result = new ArrayList<Date>(count);
        long step = isMatchSecond ? Fields.Units.SECOND.getUnit() : Fields.Units.MINUTE.getUnit();
        for (long i = start; i < end; i += step) {
            if (!pattern.match(i, isMatchSecond)) continue;
            result.add(DateKit.date(i));
            if (result.size() >= count) break;
        }
        return result;
    }

    public boolean match(long millis, boolean isMatchSecond) {
        return this.match(TimeZone.getDefault(), millis, isMatchSecond);
    }

    public boolean match(TimeZone timezone, long millis, boolean isMatchSecond) {
        GregorianCalendar calendar = new GregorianCalendar(timezone);
        calendar.setTimeInMillis(millis);
        return this.match(calendar, isMatchSecond);
    }

    public boolean match(Calendar calendar, boolean isMatchSecond) {
        return this.match(CronPattern.getFields(calendar, isMatchSecond));
    }

    private boolean match(int[] fields) {
        for (PatternMatcher matcher : this.matchers) {
            if (!matcher.match(fields)) continue;
            return true;
        }
        return false;
    }

    public boolean match(LocalDateTime dateTime, boolean isMatchSecond) {
        return this.match(CronPattern.getFields(dateTime, isMatchSecond));
    }

    public Calendar nextMatchAfter(Calendar calendar) {
        Calendar next = this.nextMatchAfter(CronPattern.getFields(calendar, true), calendar.getTimeZone());
        if (!this.match(next, true)) {
            next.set(5, next.get(5) + 1);
            next = Almanac.beginOfDay(next);
            return this.nextMatchAfter(next);
        }
        return next;
    }

    private Calendar nextMatchAfter(int[] values, TimeZone zone) {
        ArrayList<Calendar> nextMatches = new ArrayList<Calendar>(this.matchers.size());
        for (PatternMatcher matcher : this.matchers) {
            nextMatches.add(matcher.nextMatchAfter(values, zone));
        }
        return (Calendar)CollKit.min(nextMatches);
    }

    public String toString() {
        return this.pattern;
    }
}

