/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.aoju.bus.core.exception.CryptoException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.KeyType;

public interface Decryptor {
    public byte[] decrypt(byte[] var1, KeyType var2);

    default public byte[] decrypt(InputStream data, KeyType keyType) throws CryptoException {
        return this.decrypt(IoKit.readBytes(data), keyType);
    }

    default public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(Builder.decode(data), keyType);
    }

    default public String decryptString(String data, KeyType keyType, Charset charset) {
        return StringKit.toString(this.decrypt(data, keyType), charset);
    }

    default public String decryptString(String data, KeyType keyType) {
        return this.decryptString(data, keyType, org.aoju.bus.core.lang.Charset.UTF_8);
    }
}

