/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.pinyin;

import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.pinyin.PinyinFactory;
import org.aoju.bus.extra.pinyin.PinyinProvider;

public class PinyinKit {
    public static PinyinProvider getProvider() {
        return PinyinFactory.get();
    }

    public static String getPinyin(char c) {
        return PinyinKit.getProvider().getPinyin(c);
    }

    public static String getPinyin(String text) {
        return PinyinKit.getPinyin(text, " ");
    }

    public static String getPinyin(String text, String separator) {
        return PinyinKit.getProvider().getPinyin(text, separator);
    }

    public static char getFirstLetter(char c) {
        return PinyinKit.getProvider().getFirstLetter(c);
    }

    public static String getFirstLetter(String text, String separator) {
        return PinyinKit.getProvider().getFirstLetter(text, separator);
    }

    private static int getChsAscii(String chs) {
        byte[] bytes = chs.getBytes(Charset.GBK);
        return switch (bytes.length) {
            case 1 -> bytes[0];
            case 2 -> {
                int hightByte = 256 + bytes[0];
                int lowByte = 256 + bytes[1];
                yield 256 * hightByte + lowByte - 65536;
            }
            default -> throw new InternalException("Illegal resource string");
        };
    }

    public static boolean isChinese(char c) {
        return '\u3007' == c || String.valueOf(c).matches("[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]");
    }

    public static boolean isChinese(String c) {
        if (StringKit.isEmpty(c)) {
            return false;
        }
        return c.matches("[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]");
    }
}

