/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.filter;

import jakarta.annotation.PostConstruct;
import java.nio.CharBuffer;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.AES;
import org.aoju.bus.crypto.symmetric.Crypto;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.goalie.Config;
import org.aoju.bus.goalie.Context;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Order(value=0x7FFFFFFE)
public class EncryptFilter
implements WebFilter {
    private Config.Encrypt encrypt;
    private Crypto crypto;

    public EncryptFilter(Config.Encrypt encrypt) {
        this.encrypt = encrypt;
    }

    @PostConstruct
    public void init() {
        if (Algorithm.AES.getValue().equals(this.encrypt.getType())) {
            this.crypto = new AES(Mode.CBC, Padding.PKCS7Padding, this.encrypt.getKey().getBytes(), this.encrypt.getOffset().getBytes());
        }
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.encrypt.isEnabled() && (Context.Format.xml.equals((Object)Context.get(exchange).getFormat()) || Context.Format.json.equals((Object)Context.get(exchange).getFormat()))) {
            exchange = exchange.mutate().response((ServerHttpResponse)this.process(exchange)).build();
        }
        return chain.filter(exchange);
    }

    private void doEncrypt(Message message) {
        if (ObjectKit.isNotNull(message.getData()) && Algorithm.AES.getValue().equals(this.encrypt.getType())) {
            message.setData(this.crypto.encryptBase64(JsonKit.toJsonString(message.getData()), Charset.UTF_8));
        }
    }

    private ServerHttpResponseDecorator process(final ServerWebExchange exchange) {
        return new ServerHttpResponseDecorator(exchange.getResponse()){

            public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                boolean isSign = Context.get(exchange).getAssets().isSign();
                if (isSign) {
                    Flux flux = Flux.from(body);
                    return super.writeWith((Publisher)DataBufferUtils.join((Publisher)flux).map(dataBuffer -> {
                        CharBuffer charBuffer = Charset.UTF_8.decode(dataBuffer.asByteBuffer());
                        DataBufferUtils.release((DataBuffer)dataBuffer);
                        Message message = JsonKit.toPojo(charBuffer.toString(), Message.class);
                        EncryptFilter.this.doEncrypt(message);
                        return this.bufferFactory().wrap(JsonKit.toJsonString(message).getBytes());
                    }));
                }
                return super.writeWith(body);
            }
        };
    }
}

