/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.annotation.NotThreadSafe;
import org.aoju.bus.health.Builder;

@NotThreadSafe
public final class Config {
    public static final String PROPERTIES = "bus.health.properties";
    public static final String FILENAME_PROPERTIES = "bus.health.linux.filename.properties";
    public static final String MACOS_VERSIONS_PROPERTIES = "bus.health.macos.version.properties";
    public static final String VM_MAC_ADDR_PROPERTIES = "bus.health.vmmacaddr.properties";
    public static final String ARCHITECTURE_PROPERTIES = "bus.health.architecture.properties";
    public static final String MEMOIZER_EXPIRATION = "bus.health.memoizer.expiration";
    public static final String WMI_TIMEOUT = "bus.health.wmi.timeout";
    public static final String PROC_PATH = "bus.health.proc.path";
    public static final String PSEUDO_FILESYSTEM_TYPES = "bus.health.pseudo.filesystem.types";
    public static final String NETWORK_FILESYSTEM_TYPES = "bus.health.network.filesystem.types";
    public static final String OS_LINUX_PROCFS_LOGWARNING = "bus.os.linux.procfs.logwarning";
    public static final String OS_MAC_SYSCTL_LOGWARNING = "bus.os.mac.sysctl.logwarning";
    public static final String OS_WINDOWS_EVENTLOG = "bus.health.os.windows.eventlog";
    public static final String OS_WINDOWS_PROCSTATE_SUSPENDED = "bus.health.os.windows.procstate.suspended";
    public static final String OS_WINDOWS_COMMANDLINE_BATCH = "bus.health.os.windows.commandline.batch";
    public static final String OS_WINDOWS_HKEYPERFDATA = "bus.health.os.windows.hkeyperfdata";
    public static final String OSHI_OS_WINDOWS_LOADAVERAGE = "bus.health.os.windows.loadaverage";
    public static final String OS_WINDOWS_CPU_UTILITY = "bus.health.os.windows.cpu.utility";
    public static final String OS_WINDOWS_PERFDISK_DIABLED = "bus.os.windows.perfdisk.disabled";
    public static final String OS_WINDOWS_PERFOS_DIABLED = "bus.os.windows.perfos.disabled";
    public static final String OS_WINDOWS_PERFPROC_DIABLED = "bus.os.windows.perfproc.disabled";
    public static final String OS_UNIX_WHOCOMMAND = "bus.health.os.unix.whoCommand";
    private static final Properties CONFIG = Config.readProperties("bus.health.properties");

    public static String get(String key) {
        return CONFIG.getProperty(key);
    }

    public static String get(String key, String def) {
        return CONFIG.getProperty(key, def);
    }

    public static int get(String key, int def) {
        String value = CONFIG.getProperty(key);
        return null == value ? def : Builder.parseIntOrDefault(value, def);
    }

    public static double get(String key, double def) {
        String value = CONFIG.getProperty(key);
        return null == value ? def : Builder.parseDoubleOrDefault(value, def);
    }

    public static boolean get(String key, boolean def) {
        String value = CONFIG.getProperty(key);
        return null == value ? def : Boolean.parseBoolean(value);
    }

    public static void set(String key, Object val) {
        if (null == val) {
            CONFIG.remove(key);
        } else {
            CONFIG.setProperty(key, val.toString());
        }
    }

    public static void remove(String key) {
        CONFIG.remove(key);
    }

    public static void clear() {
        CONFIG.clear();
    }

    public static void load(Properties properties) {
        CONFIG.putAll((Map<?, ?>)properties);
    }

    public static Properties readProperties(String fileName) {
        return new org.aoju.bus.setting.magic.Properties("/META-INF/health/" + fileName);
    }

    public static class PropertyException
    extends RuntimeException {
        private static final long serialVersionUID = -7482581936621748005L;

        public PropertyException(String property) {
            super("Invalid property: \"" + property + "\" = " + Config.get(property, null));
        }

        public PropertyException(String property, String message) {
            super("Invalid property \"" + property + "\": " + message);
        }
    }
}

