/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix;

import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractNetworkIF;
import org.aoju.bus.health.builtin.hardware.NetworkIF;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class BsdNetworkIF
extends AbstractNetworkIF {
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long timeStamp;

    public BsdNetworkIF(NetworkInterface netint) throws InstantiationException {
        super(netint);
        this.updateAttributes();
    }

    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        ArrayList<NetworkIF> ifList = new ArrayList<NetworkIF>();
        for (NetworkInterface ni : BsdNetworkIF.getNetworkInterfaces(includeLocalInterfaces)) {
            try {
                ifList.add(new BsdNetworkIF(ni));
            }
            catch (InstantiationException e) {
                Logger.debug("Network Interface Instantiation failed: {}", e.getMessage());
            }
        }
        return ifList;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return 0L;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean updateAttributes() {
        String stats = Executor.getAnswerAt("netstat -bI " + this.getName(), 1);
        this.timeStamp = System.currentTimeMillis();
        String[] split = RegEx.SPACES.split(stats);
        if (split.length < 12) {
            return false;
        }
        this.bytesSent = Builder.parseUnsignedLongOrDefault(split[10], 0L);
        this.bytesRecv = Builder.parseUnsignedLongOrDefault(split[7], 0L);
        this.packetsSent = Builder.parseUnsignedLongOrDefault(split[8], 0L);
        this.packetsRecv = Builder.parseUnsignedLongOrDefault(split[4], 0L);
        this.outErrors = Builder.parseUnsignedLongOrDefault(split[9], 0L);
        this.inErrors = Builder.parseUnsignedLongOrDefault(split[5], 0L);
        this.collisions = Builder.parseUnsignedLongOrDefault(split[11], 0L);
        this.inDrops = Builder.parseUnsignedLongOrDefault(split[6], 0L);
        return true;
    }
}

