/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import java.nio.ByteBuffer;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.unix.CLibrary;

public interface SolarisLibc
extends CLibrary {
    public static final SolarisLibc INSTANCE = (SolarisLibc)Native.load((String)"c", SolarisLibc.class);
    public static final int UTX_USERSIZE = 32;
    public static final int UTX_LINESIZE = 32;
    public static final int UTX_IDSIZE = 4;
    public static final int UTX_HOSTSIZE = 257;
    public static final int PRCLSZ = 8;
    public static final int PRFNSZ = 16;
    public static final int PRLNSZ = 32;
    public static final int PRARGSZ = 80;

    public SolarisUtmpx getutxent();

    public int thr_self();

    public static class Timestruc {
        public NativeLong tv_sec;
        public NativeLong tv_nsec;

        public Timestruc(ByteBuffer buff) {
            this.tv_sec = Builder.readNativeLongFromBuffer(buff);
            this.tv_nsec = Builder.readNativeLongFromBuffer(buff);
        }
    }

    public static class SolarisPrUsage {
        public int pr_lwpid;
        public int pr_count;
        public Timestruc pr_tstamp;
        public Timestruc pr_create;
        public Timestruc pr_term;
        public Timestruc pr_rtime;
        public Timestruc pr_utime;
        public Timestruc pr_stime;
        public Timestruc pr_ttime;
        public Timestruc pr_tftime;
        public Timestruc pr_dftime;
        public Timestruc pr_kftime;
        public Timestruc pr_ltime;
        public Timestruc pr_slptime;
        public Timestruc pr_wtime;
        public Timestruc pr_stoptime;
        public Timestruc[] filltime = new Timestruc[6];
        public NativeLong pr_minf;
        public NativeLong pr_majf;
        public NativeLong pr_nswap;
        public NativeLong pr_inblk;
        public NativeLong pr_oublk;
        public NativeLong pr_msnd;
        public NativeLong pr_mrcv;
        public NativeLong pr_sigs;
        public NativeLong pr_vctx;
        public NativeLong pr_ictx;
        public NativeLong pr_sysc;
        public NativeLong pr_ioch;
        public NativeLong[] filler = new NativeLong[10];

        public SolarisPrUsage(ByteBuffer buff) {
            int i;
            this.pr_lwpid = Builder.readIntFromBuffer(buff);
            this.pr_count = Builder.readIntFromBuffer(buff);
            this.pr_tstamp = new Timestruc(buff);
            this.pr_create = new Timestruc(buff);
            this.pr_term = new Timestruc(buff);
            this.pr_rtime = new Timestruc(buff);
            this.pr_utime = new Timestruc(buff);
            this.pr_stime = new Timestruc(buff);
            this.pr_ttime = new Timestruc(buff);
            this.pr_tftime = new Timestruc(buff);
            this.pr_dftime = new Timestruc(buff);
            this.pr_kftime = new Timestruc(buff);
            this.pr_ltime = new Timestruc(buff);
            this.pr_slptime = new Timestruc(buff);
            this.pr_wtime = new Timestruc(buff);
            this.pr_stoptime = new Timestruc(buff);
            for (i = 0; i < this.filltime.length; ++i) {
                this.filltime[i] = new Timestruc(buff);
            }
            this.pr_minf = Builder.readNativeLongFromBuffer(buff);
            this.pr_majf = Builder.readNativeLongFromBuffer(buff);
            this.pr_nswap = Builder.readNativeLongFromBuffer(buff);
            this.pr_inblk = Builder.readNativeLongFromBuffer(buff);
            this.pr_oublk = Builder.readNativeLongFromBuffer(buff);
            this.pr_msnd = Builder.readNativeLongFromBuffer(buff);
            this.pr_mrcv = Builder.readNativeLongFromBuffer(buff);
            this.pr_sigs = Builder.readNativeLongFromBuffer(buff);
            this.pr_vctx = Builder.readNativeLongFromBuffer(buff);
            this.pr_ictx = Builder.readNativeLongFromBuffer(buff);
            this.pr_sysc = Builder.readNativeLongFromBuffer(buff);
            this.pr_ioch = Builder.readNativeLongFromBuffer(buff);
            for (i = 0; i < this.filler.length; ++i) {
                this.filler[i] = Builder.readNativeLongFromBuffer(buff);
            }
        }
    }

    public static class SolarisLwpsInfo {
        public int pr_flag;
        public int pr_lwpid;
        public Pointer pr_addr;
        public Pointer pr_wchan;
        public byte pr_stype;
        public byte pr_state;
        public byte pr_sname;
        public byte pr_nice;
        public short pr_syscall;
        public byte pr_oldpri;
        public byte pr_cpu;
        public int pr_pri;
        public short pr_pctcpu;
        public short pr_pad;
        public Timestruc pr_start;
        public Timestruc pr_time;
        public byte[] pr_clname = new byte[8];
        public byte[] pr_oldname = new byte[16];
        public int pr_onpro;
        public int pr_bindpro;
        public int pr_bindpset;
        public int pr_lgrp;
        public long pr_last_onproc;
        public byte[] pr_name = new byte[32];

        public SolarisLwpsInfo(ByteBuffer buff) {
            this.pr_flag = Builder.readIntFromBuffer(buff);
            this.pr_lwpid = Builder.readIntFromBuffer(buff);
            this.pr_addr = Builder.readPointerFromBuffer(buff);
            this.pr_wchan = Builder.readPointerFromBuffer(buff);
            this.pr_stype = Builder.readByteFromBuffer(buff);
            this.pr_state = Builder.readByteFromBuffer(buff);
            this.pr_sname = Builder.readByteFromBuffer(buff);
            this.pr_nice = Builder.readByteFromBuffer(buff);
            this.pr_syscall = Builder.readShortFromBuffer(buff);
            this.pr_oldpri = Builder.readByteFromBuffer(buff);
            this.pr_cpu = Builder.readByteFromBuffer(buff);
            this.pr_pri = Builder.readIntFromBuffer(buff);
            this.pr_pctcpu = Builder.readShortFromBuffer(buff);
            this.pr_pad = Builder.readShortFromBuffer(buff);
            this.pr_start = new Timestruc(buff);
            this.pr_time = new Timestruc(buff);
            Builder.readByteArrayFromBuffer(buff, this.pr_clname);
            Builder.readByteArrayFromBuffer(buff, this.pr_oldname);
            this.pr_onpro = Builder.readIntFromBuffer(buff);
            this.pr_bindpro = Builder.readIntFromBuffer(buff);
            this.pr_bindpset = Builder.readIntFromBuffer(buff);
            this.pr_lgrp = Builder.readIntFromBuffer(buff);
            this.pr_last_onproc = Builder.readLongFromBuffer(buff);
            Builder.readByteArrayFromBuffer(buff, this.pr_name);
        }
    }

    public static class SolarisPsInfo {
        public int pr_flag;
        public int pr_nlwp;
        public int pr_pid;
        public int pr_ppid;
        public int pr_pgid;
        public int pr_sid;
        public int pr_uid;
        public int pr_euid;
        public int pr_gid;
        public int pr_egid;
        public Pointer pr_addr;
        public LibCAPI.size_t pr_size;
        public LibCAPI.size_t pr_rssize;
        public LibCAPI.size_t pr_rssizepriv;
        public NativeLong pr_ttydev;
        public short pr_pctcpu;
        public short pr_pctmem;
        public Timestruc pr_start;
        public Timestruc pr_time;
        public Timestruc pr_ctime;
        public byte[] pr_fname = new byte[16];
        public byte[] pr_psargs = new byte[80];
        public int pr_wstat;
        public int pr_argc;
        public Pointer pr_argv;
        public Pointer pr_envp;
        public byte pr_dmodel;
        public byte[] pr_pad2 = new byte[3];
        public int pr_taskid;
        public int pr_projid;
        public int pr_nzomb;
        public int pr_poolid;
        public int pr_zoneid;
        public int pr_contract;
        public int pr_filler;
        public SolarisLwpsInfo pr_lwp;

        public SolarisPsInfo(ByteBuffer buff) {
            this.pr_flag = Builder.readIntFromBuffer(buff);
            this.pr_nlwp = Builder.readIntFromBuffer(buff);
            this.pr_pid = Builder.readIntFromBuffer(buff);
            this.pr_ppid = Builder.readIntFromBuffer(buff);
            this.pr_pgid = Builder.readIntFromBuffer(buff);
            this.pr_sid = Builder.readIntFromBuffer(buff);
            this.pr_uid = Builder.readIntFromBuffer(buff);
            this.pr_euid = Builder.readIntFromBuffer(buff);
            this.pr_gid = Builder.readIntFromBuffer(buff);
            this.pr_egid = Builder.readIntFromBuffer(buff);
            this.pr_addr = Builder.readPointerFromBuffer(buff);
            this.pr_size = Builder.readSizeTFromBuffer(buff);
            this.pr_rssize = Builder.readSizeTFromBuffer(buff);
            this.pr_rssizepriv = Builder.readSizeTFromBuffer(buff);
            this.pr_ttydev = Builder.readNativeLongFromBuffer(buff);
            this.pr_pctcpu = Builder.readShortFromBuffer(buff);
            this.pr_pctmem = Builder.readShortFromBuffer(buff);
            if (Native.LONG_SIZE > 4) {
                Builder.readIntFromBuffer(buff);
            }
            this.pr_start = new Timestruc(buff);
            this.pr_time = new Timestruc(buff);
            this.pr_ctime = new Timestruc(buff);
            Builder.readByteArrayFromBuffer(buff, this.pr_fname);
            Builder.readByteArrayFromBuffer(buff, this.pr_psargs);
            this.pr_wstat = Builder.readIntFromBuffer(buff);
            this.pr_argc = Builder.readIntFromBuffer(buff);
            this.pr_argv = Builder.readPointerFromBuffer(buff);
            this.pr_envp = Builder.readPointerFromBuffer(buff);
            this.pr_dmodel = Builder.readByteFromBuffer(buff);
            Builder.readByteArrayFromBuffer(buff, this.pr_pad2);
            this.pr_taskid = Builder.readIntFromBuffer(buff);
            this.pr_projid = Builder.readIntFromBuffer(buff);
            this.pr_nzomb = Builder.readIntFromBuffer(buff);
            this.pr_poolid = Builder.readIntFromBuffer(buff);
            this.pr_zoneid = Builder.readIntFromBuffer(buff);
            this.pr_contract = Builder.readIntFromBuffer(buff);
            this.pr_filler = Builder.readIntFromBuffer(buff);
            this.pr_lwp = new SolarisLwpsInfo(buff);
        }
    }

    @Structure.FieldOrder(value={"tv_sec", "tv_usec"})
    public static class Timeval
    extends Structure {
        public NativeLong tv_sec;
        public NativeLong tv_usec;
    }

    @Structure.FieldOrder(value={"e_termination", "e_exit"})
    public static class Exit_status
    extends Structure {
        public short e_termination;
        public short e_exit;
    }

    @Structure.FieldOrder(value={"ut_user", "ut_id", "ut_line", "ut_pid", "ut_type", "ut_exit", "ut_tv", "ut_session", "pad", "ut_syslen", "ut_host"})
    public static class SolarisUtmpx
    extends Structure {
        public byte[] ut_user = new byte[32];
        public byte[] ut_id = new byte[4];
        public byte[] ut_line = new byte[32];
        public int ut_pid;
        public short ut_type;
        public Exit_status ut_exit;
        public Timeval ut_tv;
        public int ut_session;
        public int[] pad = new int[5];
        public short ut_syslen;
        public byte[] ut_host = new byte[257];
    }
}

