/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.IOException;

public enum Protocol {
    HTTP_1_0("HTTP/1.0"),
    HTTP_1_1("HTTP/1.1"),
    HTTP_2("h2"),
    SPDY_3("SPDY/3.1"),
    H2_PRIOR_KNOWLEDGE("H2_PRIOR_KNOWLEDGE"),
    QUIC("QUIC"),
    SOAP_1_1("SOAP 1.1 Protocol"),
    SOAP_1_2("SOAP 1.2 Protocol");

    private final String protocol;

    private Protocol(String protocol) {
        this.protocol = protocol;
    }

    public static Protocol get(String protocol) throws IOException {
        if (protocol.equals(Protocol.HTTP_1_0.protocol)) {
            return HTTP_1_0;
        }
        if (protocol.equals(Protocol.HTTP_1_1.protocol)) {
            return HTTP_1_1;
        }
        if (protocol.equals(Protocol.H2_PRIOR_KNOWLEDGE.protocol)) {
            return H2_PRIOR_KNOWLEDGE;
        }
        if (protocol.equals(Protocol.HTTP_2.protocol)) {
            return HTTP_2;
        }
        if (protocol.equals(Protocol.SPDY_3.protocol)) {
            return SPDY_3;
        }
        if (protocol.equals(Protocol.QUIC.protocol)) {
            return QUIC;
        }
        if (protocol.equals(Protocol.SOAP_1_1.protocol)) {
            return SOAP_1_1;
        }
        if (protocol.equals(Protocol.SOAP_1_2.protocol)) {
            return SOAP_1_2;
        }
        throw new IOException("Unexpected protocol: " + protocol);
    }

    public String toString() {
        return this.protocol;
    }
}

