/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpz;

import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.aoju.bus.core.net.tls.SSLContextBuilder;
import org.aoju.bus.http.DnsX;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.Httpz;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.accord.ConnectionPool;
import org.aoju.bus.http.accord.ConnectionSuite;
import org.aoju.bus.http.cache.Cache;
import org.aoju.bus.http.metric.CookieJar;
import org.aoju.bus.http.metric.Dispatcher;
import org.aoju.bus.http.metric.Interceptor;
import org.aoju.bus.http.secure.Authenticator;
import org.aoju.bus.http.secure.CertificatePinner;

public class HttpBuilder {
    private Httpd.Builder builder;

    public HttpBuilder() {
        this.builder = new Httpd.Builder();
    }

    public HttpBuilder(Httpd httpd) {
        this.builder = httpd.newBuilder();
    }

    public HttpBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.builder.connectTimeout(timeout, unit);
        return this;
    }

    public HttpBuilder readTimeout(long timeout, TimeUnit unit) {
        this.builder.readTimeout(timeout, unit);
        return this;
    }

    public HttpBuilder writeTimeout(long timeout, TimeUnit unit) {
        this.builder.writeTimeout(timeout, unit);
        return this;
    }

    public HttpBuilder pingInterval(long interval, TimeUnit unit) {
        this.builder.pingInterval(interval, unit);
        return this;
    }

    public HttpBuilder proxy(Proxy proxy) {
        this.builder.proxy(proxy);
        return this;
    }

    public HttpBuilder proxySelector(ProxySelector proxySelector) {
        this.builder.proxySelector(proxySelector);
        return this;
    }

    public HttpBuilder cookieJar(CookieJar cookieJar) {
        this.builder.cookieJar(cookieJar);
        return this;
    }

    public HttpBuilder cache(Cache cache) {
        this.builder.cache(cache);
        return this;
    }

    public HttpBuilder dns(DnsX dnsX) {
        this.builder.dns(dnsX);
        return this;
    }

    public HttpBuilder socketFactory(SocketFactory socketFactory) {
        this.builder.socketFactory(socketFactory);
        return this;
    }

    public HttpBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.builder.sslSocketFactory(sslSocketFactory);
        return this;
    }

    public HttpBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.builder.sslSocketFactory(sslSocketFactory, trustManager);
        return this;
    }

    public HttpBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.builder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public HttpBuilder certificatePinner(CertificatePinner certificatePinner) {
        this.builder.certificatePinner(certificatePinner);
        return this;
    }

    public HttpBuilder authenticator(Authenticator authenticator) {
        this.builder.authenticator(authenticator);
        return this;
    }

    public HttpBuilder proxyAuthenticator(Authenticator proxyAuthenticator) {
        this.builder.proxyAuthenticator(proxyAuthenticator);
        return this;
    }

    public HttpBuilder connectionPool(ConnectionPool connectPool) {
        this.builder.connectionPool(connectPool);
        return this;
    }

    public HttpBuilder followSslRedirects(boolean followProtocolRedirects) {
        this.builder.followSslRedirects(followProtocolRedirects);
        return this;
    }

    public HttpBuilder followRedirects(boolean followRedirects) {
        this.builder.followRedirects(followRedirects);
        return this;
    }

    public HttpBuilder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.builder.retryOnConnectionFailure(retryOnConnectionFailure);
        return this;
    }

    public HttpBuilder dispatcher(Dispatcher dispatcher) {
        this.builder.dispatcher(dispatcher);
        return this;
    }

    public HttpBuilder protocols(List<Protocol> protocols) {
        this.builder.protocols(protocols);
        return this;
    }

    public HttpBuilder connectionSpecs(List<ConnectionSuite> connectSuites) {
        this.builder.connectionSpecs(connectSuites);
        return this;
    }

    public HttpBuilder addInterceptor(Interceptor interceptor) {
        this.builder.addInterceptor(interceptor);
        return this;
    }

    public HttpBuilder addNetworkInterceptor(Interceptor interceptor) {
        this.builder.addNetworkInterceptor(interceptor);
        return this;
    }

    public Httpd.Builder getBuilder() {
        return this.builder;
    }

    public HttpBuilder sslContext(SSLContext sslContext) {
        this.builder.sslSocketFactory(sslContext.getSocketFactory(), SSLContextBuilder.newTrustManager()).hostnameVerifier((hostname, session) -> true);
        return this;
    }

    public Httpz.Client build() {
        return new Httpz.Client(this.builder.build());
    }
}

