/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.pdu;

import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.Property;

public class CommonExtended {
    private final String sopCUID;
    private final String serviceCUID;
    private final String[] relSopCUIDs;

    public CommonExtended(String sopCUID, String serviceCUID, String ... relSopCUIDs) {
        if (null == sopCUID) {
            throw new NullPointerException("sopCUID");
        }
        if (null == serviceCUID) {
            throw new NullPointerException("serviceCUID");
        }
        this.sopCUID = sopCUID;
        this.serviceCUID = serviceCUID;
        this.relSopCUIDs = relSopCUIDs;
    }

    public final String getSOPClassUID() {
        return this.sopCUID;
    }

    public final String getServiceClassUID() {
        return this.serviceCUID;
    }

    public String[] getRelatedGeneralSOPClassUIDs() {
        return this.relSopCUIDs;
    }

    public int length() {
        return 6 + this.sopCUID.length() + this.serviceCUID.length() + this.getRelatedGeneralSOPClassUIDsLength();
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder sb) {
        sb.append("  CommonExtendedNegotiation[").append(Property.LINE_SEPARATOR).append("    sopClass: ");
        UID.promptTo(this.sopCUID, sb).append(Property.LINE_SEPARATOR).append("    serviceClass: ");
        UID.promptTo(this.serviceCUID, sb).append(Property.LINE_SEPARATOR);
        if (this.relSopCUIDs.length != 0) {
            sb.append("    relatedSOPClasses:").append(Property.LINE_SEPARATOR);
            for (String uid : this.relSopCUIDs) {
                UID.promptTo(uid, sb.append("      ")).append(Property.LINE_SEPARATOR);
            }
        }
        return sb.append("  ]");
    }

    public int getRelatedGeneralSOPClassUIDsLength() {
        int len = 0;
        for (String cuid : this.relSopCUIDs) {
            len += 2 + cuid.length();
        }
        return len;
    }
}

