/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.nimble.codec.BytesWithImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.opencv.ExtendInputImageStream;
import org.aoju.bus.image.nimble.opencv.FileStreamSegment;
import org.aoju.bus.image.nimble.opencv.MemoryStreamSegment;
import org.aoju.bus.image.nimble.stream.SegmentedImageStream;
import org.aoju.bus.logger.Logger;

public abstract class StreamSegment {
    private final long[] segPosition;
    private final long[] segLength;
    private final ImageDescriptor imageDescriptor;

    StreamSegment(long[] startPos, long[] length, ImageDescriptor imageDescriptor) {
        this.segPosition = startPos;
        this.segLength = length;
        this.imageDescriptor = imageDescriptor;
    }

    public static StreamSegment getStreamSegment(ImageInputStream iis, ImageReadParam param) throws IOException {
        if (iis instanceof ExtendInputImageStream) {
            return new FileStreamSegment((ExtendInputImageStream)((Object)iis));
        }
        if (iis instanceof SegmentedImageStream) {
            return StreamSegment.getFileStreamSegment((SegmentedImageStream)iis);
        }
        if (iis instanceof FileCacheImageInputStream) {
            throw new IllegalArgumentException("No adaptor implemented yet for FileCacheImageInputStream");
        }
        if (iis instanceof BytesWithImageDescriptor) {
            BytesWithImageDescriptor stream = (BytesWithImageDescriptor)((Object)iis);
            return new MemoryStreamSegment(stream.getBytes(), stream.getImageDescriptor());
        }
        throw new IllegalArgumentException("No stream adaptor found for " + iis.getClass().getName() + "!");
    }

    private static StreamSegment getFileStreamSegment(SegmentedImageStream iis) {
        try {
            Class<?> clazz = iis.getClass();
            Field fStream = clazz.getDeclaredField("stream");
            Field fCurSegment = clazz.getDeclaredField("curSegment");
            if (null != fCurSegment && null != fStream) {
                long[][] seg;
                MemoryCacheImageInputStream mstream;
                byte[] b;
                fCurSegment.setAccessible(true);
                fStream.setAccessible(true);
                ImageInputStream fstream = (ImageInputStream)fStream.get(iis);
                Field fRaf = null;
                if (fstream instanceof FileImageInputStream) {
                    fRaf = FileImageInputStream.class.getDeclaredField("raf");
                } else if (fstream instanceof FileCacheImageInputStream) {
                    fRaf = FileCacheImageInputStream.class.getDeclaredField("cache");
                }
                if (null != fRaf) {
                    fRaf.setAccessible(true);
                    long[][] seg2 = StreamSegment.getSegments(iis, clazz, fCurSegment);
                    if (null != seg2) {
                        RandomAccessFile raf = (RandomAccessFile)fRaf.get(fstream);
                        return new FileStreamSegment(raf, seg2[0], seg2[1], iis.getImageDescriptor());
                    }
                }
                if (fstream instanceof MemoryCacheImageInputStream && null != (b = StreamSegment.getByte(MemoryStreamSegment.getByteArrayInputStream(mstream = (MemoryCacheImageInputStream)fstream))) && null != (seg = StreamSegment.getSegments(iis, clazz, fCurSegment))) {
                    int offset = (int)seg[0][0];
                    return new MemoryStreamSegment(ByteBuffer.wrap(Arrays.copyOfRange(b, offset, offset + (int)seg[1][0])), iis.getImageDescriptor());
                }
                Logger.error("Cannot read SegmentedInputImageStream with {} ", fstream.getClass());
            }
        }
        catch (Exception e) {
            Logger.error("Building FileStreamSegment from SegmentedInputImageStream", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[][] getSegments(SegmentedImageStream iis, Class<? extends ImageInputStream> clazz, Field fCurSegment) throws Exception {
        Integer curSegment = (Integer)fCurSegment.get(iis);
        if (null != curSegment && curSegment >= 0) {
            ImageDescriptor desc = iis.getImageDescriptor();
            Field ffragments = clazz.getDeclaredField("fragments");
            Field flastSegment = clazz.getDeclaredField("lastSegment");
            if (null != ffragments && null != flastSegment) {
                ffragments.setAccessible(true);
                flastSegment.setAccessible(true);
                List fragments = (List)ffragments.get(iis);
                Integer lastSegment = (Integer)flastSegment.get(iis);
                if (!desc.isMultiframe() && lastSegment < fragments.size()) {
                    lastSegment = fragments.size();
                }
                long[] segPositions = new long[lastSegment - curSegment];
                long[] segLength = new long[segPositions.length];
                long beforePos = 0L;
                for (int i = curSegment.intValue(); i < lastSegment; ++i) {
                    List list = fragments;
                    synchronized (list) {
                        if (i < fragments.size()) {
                            Object fragment = fragments.get(i);
                            int k = i - curSegment;
                            if (fragment instanceof BulkData) {
                                BulkData bulk = (BulkData)fragment;
                                segPositions[k] = bulk.offset();
                                segLength[k] = bulk.length();
                            } else {
                                byte[] byteFrag = (byte[])fragment;
                                segPositions[k] = beforePos;
                                segLength[k] = byteFrag.length;
                            }
                            beforePos += segLength[k] & 0xFFFFFFFFL;
                        }
                        continue;
                    }
                }
                return new long[][]{segPositions, segLength};
            }
        }
        return null;
    }

    public static byte[] getByte(ByteArrayInputStream inputStream) {
        if (null != inputStream) {
            try {
                Field fid = ByteArrayInputStream.class.getDeclaredField("buf");
                if (null != fid) {
                    fid.setAccessible(true);
                    return (byte[])fid.get(inputStream);
                }
            }
            catch (Exception e) {
                Logger.error("Cannot get bytes from inputstream", e);
            }
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public long[] getSegPosition() {
        return this.segPosition;
    }

    public long[] getSegLength() {
        return this.segLength;
    }
}

