/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.ExtendedNegotiate;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.logger.Logger;

public class MoveSCU
extends Device
implements AutoCloseable {
    private static final int[] DEF_IN_FILTER = new int[]{524312, 0x20000D, 0x20000E};
    private final ApplicationEntity ae = new ApplicationEntity("MOVESCU");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final transient AAssociateRQ rq = new AAssociateRQ();
    private final transient Status state;
    private int priority;
    private String destination;
    private InformationModel model;
    private Attributes keys = new Attributes();
    private int[] inFilter = DEF_IN_FILTER;
    private transient Association as;

    public MoveSCU() {
        this((Progress)null);
    }

    public MoveSCU(Progress progress) {
        super("movescu");
        this.addConnection(this.conn);
        this.addApplicationEntity(this.ae);
        this.ae.addConnection(this.conn);
        this.state = new Status(progress);
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setInformationModel(InformationModel model, String[] tss, boolean relational) {
        this.model = model;
        this.rq.addPresentationContext(new Presentation(1, model.cuid, tss));
        if (relational) {
            this.rq.addExtendedNegotiate(new ExtendedNegotiate(model.cuid, new byte[]{1}));
        }
        if (null != model.level) {
            this.addLevel(model.level);
        }
    }

    public void addLevel(String s) {
        this.keys.setString(524370, VR.CS, s);
    }

    public final void setDestination(String destination) {
        this.destination = destination;
    }

    public void addKey(int tag, String ... ss) {
        VR vr = ElementDictionary.vrOf(tag, this.keys.getPrivateCreator(tag));
        this.keys.setString(tag, vr, ss);
    }

    public final void setInputFilter(int[] inFilter) {
        this.inFilter = inFilter;
    }

    public ApplicationEntity getApplicationEntity() {
        return this.ae;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public Association getAssociation() {
        return this.as;
    }

    public Attributes getKeys() {
        return this.keys;
    }

    public void open() throws IOException, InterruptedException, GeneralSecurityException {
        this.as = this.ae.connect(this.conn, this.remote, this.rq);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        if (null != this.as && this.as.isReadyForDataTransfer()) {
            this.as.waitForOutstandingRSP();
            this.as.release();
        }
    }

    public void retrieve(File f) throws IOException, InterruptedException {
        Attributes attrs = new Attributes();
        try (ImageInputStream dis = new ImageInputStream(f);){
            attrs.addSelected(dis.readDataset(-1, -1), this.inFilter);
        }
        attrs.addAll(this.keys);
        this.retrieve(attrs);
    }

    public void retrieve() throws IOException, InterruptedException {
        this.retrieve(this.keys);
    }

    private void retrieve(Attributes keys) throws IOException, InterruptedException {
        DimseRSPHandler rspHandler = new DimseRSPHandler(this.as.nextMessageID()){

            @Override
            public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                super.onDimseRSP(as, cmd, data);
                Progress p = MoveSCU.this.state.getProgress();
                if (null != p) {
                    p.setAttributes(cmd);
                    if (p.isCancel()) {
                        try {
                            this.cancel(as);
                        }
                        catch (IOException e) {
                            Logger.error("Cancel C-MOVE", e);
                        }
                    }
                }
            }
        };
        this.as.cmove(this.model.cuid, this.priority, keys, null, this.destination, rspHandler);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Status getState() {
        return this.state;
    }

    public static enum InformationModel {
        PatientRoot("1.2.840.10008.5.1.4.1.2.1.2", "STUDY"),
        StudyRoot("1.2.840.10008.5.1.4.1.2.2.2", "STUDY"),
        PatientStudyOnly("1.2.840.10008.5.1.4.1.2.3.2", "STUDY"),
        CompositeInstanceRoot("1.2.840.10008.5.1.4.1.2.4.2", "IMAGE"),
        HangingProtocol("1.2.840.10008.5.1.4.38.3", null),
        ColorPalette("1.2.840.10008.5.1.4.39.3", null);

        final String cuid;
        final String level;

        private InformationModel(String cuid, String level) {
            this.cuid = cuid;
            this.level = level;
        }

        public String getCuid() {
            return this.cuid;
        }
    }
}

