/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.builder.MapperBuilder;
import org.aoju.bus.mapper.entity.Config;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.entity.EntityTable;
import org.aoju.bus.mapper.reflect.Reflector;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;

public abstract class MapperTemplate {
    private static final XMLLanguageDriver languageDriver = new XMLLanguageDriver();
    protected Map<String, Method> methodMap = new ConcurrentHashMap<String, Method>();
    protected Map<String, Class<?>> entityClassMap = new ConcurrentHashMap();
    protected Class<?> mapperClass;
    protected MapperBuilder mapperBuilder;

    public MapperTemplate(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        this.mapperClass = mapperClass;
        this.mapperBuilder = mapperBuilder;
    }

    public String dynamicSQL(Object record) {
        return "dynamicSQL";
    }

    public void addMethodMap(String methodName, Method method) {
        this.methodMap.put(methodName, method);
    }

    public String getIDENTITY(EntityColumn column) {
        return MessageFormat.format(this.mapperBuilder.getConfig().getIDENTITY(), column.getColumn(), column.getProperty(), column.getTable().getName());
    }

    public boolean supportMethod(String msId) {
        Class<?> mapperClass = Reflector.getMapperClass(msId);
        if (mapperClass != null && this.mapperClass.isAssignableFrom(mapperClass)) {
            String methodName = Reflector.getMethodName(msId);
            return this.methodMap.get(methodName) != null;
        }
        return false;
    }

    protected void setResultType(MappedStatement ms, Class<?> entityClass) {
        EntityTable entityTable = EntityBuilder.getEntityTable(entityClass);
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(entityTable.getResultMap(ms.getConfiguration()));
        MetaObject metaObject = org.aoju.bus.mapper.reflect.MetaObject.forObject(ms);
        metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
    }

    protected void setSqlSource(MappedStatement ms, SqlSource sqlSource) {
        MetaObject msObject = org.aoju.bus.mapper.reflect.MetaObject.forObject(ms);
        msObject.setValue("sqlSource", (Object)sqlSource);
    }

    public SqlSource createSqlSource(MappedStatement ms, String xmlSql) {
        return languageDriver.createSqlSource(ms.getConfiguration(), "<script>\n\t" + xmlSql + "</script>", null);
    }

    public Class<?> getEntityClass(MappedStatement ms) {
        Type[] types;
        String msId = ms.getId();
        if (this.entityClassMap.containsKey(msId)) {
            return this.entityClassMap.get(msId);
        }
        Class<?> mapperClass = Reflector.getMapperClass(msId);
        for (Type type : types = mapperClass.getGenericInterfaces()) {
            ParameterizedType t;
            if (!(type instanceof ParameterizedType) || (t = (ParameterizedType)type).getRawType() != this.mapperClass && !this.mapperClass.isAssignableFrom((Class)t.getRawType())) continue;
            Class returnType = (Class)t.getActualTypeArguments()[0];
            EntityBuilder.initEntityNameMap(returnType, this.mapperBuilder.getConfig());
            this.entityClassMap.put(msId, returnType);
            return returnType;
        }
        throw new InternalException("\u65e0\u6cd5\u83b7\u53d6 " + msId + " \u65b9\u6cd5\u7684\u6cdb\u578b\u4fe1\u606f!");
    }

    protected String tableName(Class<?> entityClass) {
        EntityTable entityTable = EntityBuilder.getEntityTable(entityClass);
        String prefix = entityTable.getPrefix();
        if (StringKit.isEmpty(prefix)) {
            prefix = this.mapperBuilder.getConfig().getPrefix();
        }
        if (StringKit.isNotEmpty(prefix)) {
            return prefix + "." + entityTable.getName();
        }
        return entityTable.getName();
    }

    public Config getConfig() {
        return this.mapperBuilder.getConfig();
    }

    public String getIDENTITY() {
        return this.getConfig().getIDENTITY();
    }

    public boolean isBEFORE() {
        return this.getConfig().isBEFORE();
    }

    public boolean isCheckConditionEntityClass() {
        return this.getConfig().isCheckConditionEntityClass();
    }

    public boolean isNotEmpty() {
        return this.getConfig().isNotEmpty();
    }

    public void setSqlSource(MappedStatement ms) {
        block7: {
            if (this.mapperClass == Reflector.getMapperClass(ms.getId())) {
                throw new InternalException("\u8bf7\u4e0d\u8981\u914d\u7f6e\u6216\u626b\u63cf\u901a\u7528Mapper\u63a5\u53e3\u7c7b\uff1a" + String.valueOf(this.mapperClass));
            }
            Method method = this.methodMap.get(Reflector.getMethodName(ms));
            try {
                if (method.getReturnType() == Void.TYPE) {
                    method.invoke((Object)this, ms);
                    break block7;
                }
                if (SqlNode.class.isAssignableFrom(method.getReturnType())) {
                    SqlNode sqlNode = (SqlNode)method.invoke((Object)this, ms);
                    DynamicSqlSource dynamicSqlSource = new DynamicSqlSource(ms.getConfiguration(), sqlNode);
                    this.setSqlSource(ms, (SqlSource)dynamicSqlSource);
                    break block7;
                }
                if (String.class.equals(method.getReturnType())) {
                    String xmlSql = (String)method.invoke((Object)this, ms);
                    SqlSource sqlSource = this.createSqlSource(ms, xmlSql);
                    this.setSqlSource(ms, sqlSource);
                    break block7;
                }
                throw new InternalException("\u81ea\u5b9a\u4e49Mapper\u65b9\u6cd5\u8fd4\u56de\u7c7b\u578b\u9519\u8bef,\u53ef\u9009\u7684\u8fd4\u56de\u7c7b\u578b\u4e3avoid,SqlNode,String\u4e09\u79cd!");
            }
            catch (IllegalAccessException e) {
                throw new InternalException(e);
            }
            catch (InvocationTargetException e) {
                throw new InternalException(e.getTargetException() != null ? e.getTargetException() : e);
            }
        }
    }
}

