/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.provider;

import java.util.List;
import java.util.Set;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.builder.MapperBuilder;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.builder.SqlBuilder;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.apache.ibatis.mapping.MappedStatement;

public class IdListProvider
extends MapperTemplate {
    public IdListProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public static void notEmpty(List<?> list, String errorMsg) {
        if (list == null || list.size() == 0) {
            throw new InternalException(errorMsg);
        }
    }

    public String deleteByIdList(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.deleteFromTable(entityClass, this.tableName(entityClass)));
        this.appendWhereIdList(sql, entityClass, this.getConfig().isSafeDelete());
        return sql.toString();
    }

    public String selectByIdList(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        this.appendWhereIdList(sql, entityClass, this.isNotEmpty());
        return sql.toString();
    }

    private void appendWhereIdList(StringBuilder sql, Class<?> entityClass, boolean notEmpty) {
        EntityColumn column;
        Set<EntityColumn> columnList = EntityBuilder.getPKColumns(entityClass);
        if (columnList.size() == 1) {
            column = columnList.iterator().next();
            if (notEmpty) {
                sql.append("<bind name=\"notEmptyListCheck\" value=\"@org.aoju.bus.mapper.provider.IdListProvider@notEmpty(");
                sql.append("idList, 'idList \u4e0d\u80fd\u4e3a\u7a7a')\"/>");
            }
        } else {
            throw new InternalException("\u7ee7\u627f ByIdList \u65b9\u6cd5\u7684\u5b9e\u4f53\u7c7b[" + entityClass.getName() + "]\u4e2d\u5fc5\u987b\u53ea\u6709\u4e00\u4e2a\u5e26\u6709 @Id \u6ce8\u89e3\u7684\u5b57\u6bb5");
        }
        sql.append("<where>");
        sql.append("<foreach collection=\"idList\" item=\"id\" separator=\",\" open=\"");
        sql.append(column.getColumn());
        sql.append(" in ");
        sql.append("(\" close=\")\">");
        sql.append("#{id}");
        sql.append("</foreach>");
        sql.append("</where>");
    }
}

