/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelNumberFormat;

public final class Builder {
    public static final String NO_POI_ERROR_MSG = "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2";
    private static final int[] CUSTOM_FORMATS = new int[]{28, 30, 31, 32, 33, 55, 56, 57, 58};
    private static final int[] customFormats = new int[]{28, 30, 31, 32, 33, 55, 56, 57, 58};

    public static boolean isDateFormat(Cell cell) {
        return Builder.isDateFormat(cell, null);
    }

    public static boolean isDateFormat(Cell cell, ConditionalFormattingEvaluator cfEvaluator) {
        ExcelNumberFormat nf = ExcelNumberFormat.from((Cell)cell, (ConditionalFormattingEvaluator)cfEvaluator);
        return Builder.isDateFormat(nf);
    }

    public static boolean isDateFormat(ExcelNumberFormat numFmt) {
        return Builder.isDateFormat(numFmt.getIdx(), numFmt.getFormat());
    }

    public static boolean isDateFormat(int formatIndex, String formatString) {
        if (ArrayKit.contains(customFormats, formatIndex)) {
            return true;
        }
        if (StringKit.isNotEmpty(formatString) && StringKit.containsAny((CharSequence)formatString, "\u5468", "\u661f\u671f", "aa")) {
            return true;
        }
        return DateUtil.isADateFormat((int)formatIndex, (String)formatString);
    }
}

