/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.excel.sax;

import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.function.XFunction;
import org.aoju.bus.office.excel.sax.RowHandler;

public abstract class AbstractRowHandler<T>
implements RowHandler {
    protected final int startRowIndex;
    protected final int endRowIndex;
    protected XFunction<List<Object>, T> convertFunc;

    public AbstractRowHandler(int startRowIndex, int endRowIndex) {
        this.startRowIndex = startRowIndex;
        this.endRowIndex = endRowIndex;
    }

    @Override
    public void handle(int sheetIndex, long rowIndex, List<Object> rowCells) {
        Assert.notNull(this.convertFunc);
        if (rowIndex < (long)this.startRowIndex || rowIndex > (long)this.endRowIndex) {
            return;
        }
        this.handleData(sheetIndex, rowIndex, this.convertFunc.apply(rowCells));
    }

    public abstract void handleData(int var1, long var2, T var4);
}

