/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.cache;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.aoju.bus.core.exception.PageException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pager.Property;
import org.aoju.bus.pager.cache.Cache;
import org.aoju.bus.pager.cache.GuavaCache;
import org.aoju.bus.pager.cache.SimpleCache;

public abstract class CacheFactory {
    public static <K, V> Cache<K, V> createCache(String sqlCacheClass, String prefix, Properties properties) {
        if (StringKit.isEmpty(sqlCacheClass)) {
            try {
                Class.forName("com.google.common.cache.Cache");
                return new GuavaCache(properties, prefix);
            }
            catch (Throwable t) {
                return new SimpleCache(properties, prefix);
            }
        }
        try {
            Class<?> clazz = Class.forName(sqlCacheClass);
            try {
                Constructor<?> constructor = clazz.getConstructor(Properties.class, String.class);
                return (Cache)constructor.newInstance(properties, prefix);
            }
            catch (Exception e) {
                Cache cache = (Cache)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (cache instanceof Property) {
                    ((Property)((Object)cache)).setProperties(properties);
                }
                return cache;
            }
        }
        catch (Throwable t) {
            throw new PageException("Created Sql Cache [" + sqlCacheClass + "] Error", t);
        }
    }
}

