/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.metric;

import java.util.concurrent.Callable;
import org.aoju.bus.logger.Logger;

public class RetryKit {
    public static <V extends ResultCheck> V retryOnException(int retryLimit, Callable<V> retryCallable) {
        ResultCheck v = null;
        for (int i = 0; i < retryLimit; ++i) {
            try {
                v = (ResultCheck)retryCallable.call();
            }
            catch (Exception e) {
                Logger.warn("retry on " + (i + 1) + " times v = " + (v == null ? null : v.getJson()), e);
            }
            if (null != v && v.matching()) break;
            Logger.error("retry on " + (i + 1) + " times but not matching v = " + (v == null ? null : v.getJson()), new Object[0]);
        }
        return (V)v;
    }

    public static <V extends ResultCheck> V retryOnException(int retryLimit, long sleepMillis, Callable<V> retryCallable) throws InterruptedException {
        ResultCheck v = null;
        for (int i = 0; i < retryLimit; ++i) {
            try {
                v = (ResultCheck)retryCallable.call();
            }
            catch (Exception e) {
                Logger.warn("retry on " + (i + 1) + " times v = " + (v == null ? null : v.getJson()), e);
            }
            if (null != v && v.matching()) break;
            Logger.error("retry on " + (i + 1) + " times but not matching v = " + (v == null ? null : v.getJson()), new Object[0]);
            if (sleepMillis <= 0L) continue;
            Thread.sleep(sleepMillis);
        }
        return (V)v;
    }

    public static interface ResultCheck {
        public boolean matching();

        public String getJson();
    }
}

