/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider.paypal;

import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pay.Context;
import org.aoju.bus.pay.magic.Results;
import org.aoju.bus.pay.metric.PayCache;
import org.aoju.bus.pay.metric.RetryKit;
import org.aoju.bus.pay.provider.paypal.AccessToken;
import org.aoju.bus.pay.provider.paypal.PaypalProvider;

public class AccessTokenKit {
    private static final PayCache cache = PayCache.INSTANCE;

    public static AccessToken get() {
        return AccessTokenKit.get((String)cache.get("clientId"), false);
    }

    public static AccessToken get(boolean forceRefresh) {
        return AccessTokenKit.get((String)cache.get("clientId"), forceRefresh);
    }

    public static AccessToken get(String clientId) {
        return AccessTokenKit.get(clientId, false);
    }

    public static AccessToken get(String clientId, boolean forceRefresh) {
        AccessToken accessToken;
        String json;
        if (!forceRefresh && StringKit.isNotEmpty(json = (String)cache.get(clientId)) && (accessToken = new AccessToken(json, 200)).isAvailable()) {
            return accessToken;
        }
        Context context = (Context)cache.get("clientId");
        AccessToken result = RetryKit.retryOnException(3, () -> {
            Results response = PaypalProvider.getToken(context);
            return new AccessToken(response.getBody(), response.getStatus());
        });
        if (null != result) {
            cache.cache(clientId, result.getCacheJson());
        }
        return result;
    }
}

