/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.magic;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.watcher.SimpleWatcher;
import org.aoju.bus.core.io.watcher.WatchMonitor;
import org.aoju.bus.core.io.watcher.Watcher;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.function.XSupplier;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.LambdaKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.WatchKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.setting.Readers;
import org.aoju.bus.setting.magic.AbstractSetting;
import org.aoju.bus.setting.metric.GroupMap;

public class PopSetting
extends AbstractSetting
implements Map<String, String> {
    private static final long serialVersionUID = 1L;
    private final GroupMap groupMap = new GroupMap();
    protected java.nio.charset.Charset charset;
    protected boolean isUseVariable;
    protected Resource resource;
    private boolean logIfNull;
    private Readers readers;
    private WatchMonitor watchMonitor;

    public PopSetting() {
        this.charset = Charset.UTF_8;
    }

    public PopSetting(String path) {
        this(path, false);
    }

    public PopSetting(String path, boolean isUseVariable) {
        this(path, Charset.UTF_8, isUseVariable);
    }

    public PopSetting(String path, java.nio.charset.Charset charset, boolean isUseVariable) {
        Assert.notBlank(path, "Blank setting path !", new Object[0]);
        this.init(FileKit.getResource(path), charset, isUseVariable);
    }

    public PopSetting(File configFile, java.nio.charset.Charset charset, boolean isUseVariable) {
        Assert.notNull(configFile, "Null setting file define!", new Object[0]);
        this.init(FileKit.getResource(configFile), charset, isUseVariable);
    }

    public PopSetting(Resource resource, java.nio.charset.Charset charset, boolean isUseVariable) {
        this.init(resource, charset, isUseVariable);
    }

    public static PopSetting of() {
        return new PopSetting();
    }

    public boolean init(Resource resource, java.nio.charset.Charset charset, boolean isUseVariable) {
        Assert.notNull(resource, "PopSetting resource must be not null!", new Object[0]);
        this.resource = resource;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
        return this.load();
    }

    public synchronized boolean load() {
        if (null == this.readers) {
            this.readers = new Readers(this.groupMap, this.charset, this.isUseVariable);
        }
        return this.readers.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        this.autoLoad(autoReload, null);
    }

    public void autoLoad(boolean autoReload, final Consumer<Boolean> callback) {
        if (autoReload) {
            Assert.notNull(this.resource, "PopSetting resource must be not null !", new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchKit.createModify(this.resource.getUrl(), (Watcher)new SimpleWatcher(){

                @Override
                public void onModify(WatchEvent<?> event, Path currentPath) {
                    boolean success = PopSetting.this.load();
                    if (callback != null) {
                        callback.accept(success);
                    }
                }
            });
            this.watchMonitor.start();
            Logger.debug("Auto load for [{}] listenning...", this.resource.getUrl());
        } else {
            IoKit.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public URL getSettingUrl() {
        return null == this.resource ? null : this.resource.getUrl();
    }

    public String getSettingPath() {
        URL settingUrl = this.getSettingUrl();
        return null == settingUrl ? null : settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.groupMap.size();
    }

    @Override
    public Object getObjectByGroup(CharSequence key, CharSequence group, Object defaultValue) {
        String result = this.groupMap.get(group, key);
        if (result == null && this.logIfNull) {
            Logger.debug("No key [{}] in group [{}] !", key, group);
        }
        return result;
    }

    public String getAndRemove(String ... keys) {
        String key;
        String value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return value;
    }

    public Map<String, String> getMap(String group) {
        LinkedHashMap map = (LinkedHashMap)this.groupMap.get(group);
        return null != map ? map : new LinkedHashMap(0);
    }

    public PopSetting getSetting(String group) {
        PopSetting setting = new PopSetting();
        setting.putAll((Map<? extends String, ? extends String>)this.getMap(group));
        return setting;
    }

    public Properties getProperties(String group) {
        Properties properties = new Properties();
        properties.putAll(this.getMap(group));
        return properties;
    }

    public Properties getProps(String group) {
        Properties props = new Properties();
        props.putAll(this.getMap(group));
        return props;
    }

    public void store() {
        URL resourceUrl = this.getSettingUrl();
        Assert.notNull(resourceUrl, "PopSetting path must be not null !", new Object[0]);
        this.store(FileKit.file(resourceUrl));
    }

    public void store(String absolutePath) {
        this.store(FileKit.touch(absolutePath));
    }

    public void store(File file) {
        if (null == this.readers) {
            this.readers = new Readers(this.groupMap, this.charset, this.isUseVariable);
        }
        this.readers.store(file);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (Map.Entry groupEntry : this.groupMap.entrySet()) {
            String group = (String)groupEntry.getKey();
            for (Map.Entry entry : ((LinkedHashMap)groupEntry.getValue()).entrySet()) {
                properties.setProperty((String)(StringKit.isEmpty(group) ? (String)entry.getKey() : group + "." + (String)entry.getKey()), (String)entry.getValue());
            }
        }
        return properties;
    }

    public GroupMap getGroupMap() {
        return this.groupMap;
    }

    public List<String> getGroups() {
        return CollKit.newArrayList(this.groupMap.keySet());
    }

    public PopSetting setVarRegex(String regex) {
        if (null == this.readers) {
            throw new NullPointerException("SettingLoader is null !");
        }
        this.readers.setVarRegex(regex);
        return this;
    }

    public PopSetting setCharset(java.nio.charset.Charset charset) {
        this.charset = charset;
        return this;
    }

    public PopSetting setLogIfNull(boolean logIfNull) {
        this.logIfNull = logIfNull;
        return this;
    }

    public boolean isEmpty(String group) {
        return this.groupMap.isEmpty(group);
    }

    public boolean containsKey(String group, String key) {
        return this.groupMap.containsKey(group, key);
    }

    public boolean containsValue(String group, String value) {
        return this.groupMap.containsValue(group, value);
    }

    public String putByGroup(String key, String group, String value) {
        return this.groupMap.put(group, key, value);
    }

    public String remove(String group, Object key) {
        return this.groupMap.remove(group, Convert.toString(key));
    }

    public PopSetting putAll(String group, Map<? extends String, ? extends String> m) {
        this.groupMap.putAll(group, m);
        return this;
    }

    public PopSetting addSetting(PopSetting setting) {
        for (Map.Entry e : setting.getGroupMap().entrySet()) {
            this.putAll((String)e.getKey(), (Map)e.getValue());
        }
        return this;
    }

    public PopSetting clear(String group) {
        this.groupMap.clear(group);
        return this;
    }

    public Set<String> keySet(String group) {
        return this.groupMap.keySet(group);
    }

    public Collection<String> values(String group) {
        return this.groupMap.values(group);
    }

    public Set<Map.Entry<String, String>> entrySet(String group) {
        return this.groupMap.entrySet(group);
    }

    public PopSetting set(String key, String value) {
        this.put(key, value);
        return this;
    }

    public PopSetting setFields(XSupplier<String> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaKit.getFieldName(f), (String)f.get()));
        return this;
    }

    public PopSetting setByGroup(String key, String group, String value) {
        this.putByGroup(key, group, value);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.groupMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.groupMap.containsKey("", Convert.toString(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.groupMap.containsValue("", Convert.toString(value));
    }

    @Override
    public String get(Object key) {
        return this.getString((String)key);
    }

    @Override
    public String put(String key, String value) {
        return this.groupMap.put("", key, value);
    }

    @Override
    public String remove(Object key) {
        return this.remove("", key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.groupMap.putAll("", m);
    }

    @Override
    public void clear() {
        this.groupMap.clear("");
    }

    @Override
    public Set<String> keySet() {
        return this.groupMap.keySet("");
    }

    @Override
    public Collection<String> values() {
        return this.groupMap.values("");
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.groupMap.entrySet("");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (null == this.charset ? 0 : this.charset.hashCode());
        result = 31 * result + this.groupMap.hashCode();
        result = 31 * result + (this.isUseVariable ? 1231 : 1237);
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PopSetting other = (PopSetting)object;
        if (null == this.charset ? null != other.charset : false == this.charset.equals(other.charset)) {
            return false;
        }
        if (!this.groupMap.equals(other.groupMap)) {
            return false;
        }
        if (this.isUseVariable != other.isUseVariable) {
            return false;
        }
        if (this.resource == null) {
            return other.resource == null;
        }
        return this.resource.equals(other.resource);
    }

    public String toString() {
        return this.groupMap.toString();
    }
}

