/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.lang.reflect.Field;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.AioQuickServer;
import org.aoju.bus.socket.QuickTimer;
import org.aoju.bus.socket.buffers.BufferPage;
import org.aoju.bus.socket.buffers.BufferPool;
import org.aoju.bus.socket.plugins.AbstractPlugin;

public class BufferPageMonitorPlugin<T>
extends AbstractPlugin<T> {
    private int seconds = 0;
    private AioQuickServer server;
    private ScheduledFuture<?> future;

    public BufferPageMonitorPlugin(AioQuickServer server, int seconds) {
        this.seconds = seconds;
        this.server = server;
        this.init();
    }

    private void init() {
        long mills = TimeUnit.SECONDS.toMillis(this.seconds);
        this.future = QuickTimer.scheduleAtFixedRate(() -> {
            if (this.server == null) {
                Logger.error("unKnow server or client need to monitor!", new Object[0]);
                this.shutdown();
                return;
            }
            try {
                Field bufferPoolField = AioQuickServer.class.getDeclaredField("bufferPool");
                bufferPoolField.setAccessible(true);
                BufferPool pagePool = (BufferPool)bufferPoolField.get(this.server);
                if (pagePool == null) {
                    Logger.error("server maybe has not started!", new Object[0]);
                    this.shutdown();
                    return;
                }
                Field field = BufferPool.class.getDeclaredField("bufferPages");
                field.setAccessible(true);
                BufferPage[] pages = (BufferPage[])field.get(pagePool);
                Object logger = "";
                for (BufferPage page : pages) {
                    logger = (String)logger + "\r\n" + page.toString();
                }
                Logger.info((String)logger, new Object[0]);
            }
            catch (Exception e) {
                Logger.error("", e);
            }
        }, mills, mills);
    }

    private void shutdown() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }
}

