/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.QuickTimer;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.plugins.AbstractPlugin;

public abstract class HeartPlugin<T>
extends AbstractPlugin<T> {
    private static final TimeoutCallback DEFAULT_TIMEOUT_CALLBACK = (session, lastTime) -> session.close(true);
    private Map<AioSession, Long> sessionMap = new HashMap<AioSession, Long>();
    private long heartRate;
    private long timeout;
    private TimeoutCallback timeoutCallback;

    public HeartPlugin(int heartRate, TimeUnit timeUnit) {
        this(heartRate, 0, timeUnit);
    }

    public HeartPlugin(int heartRate, int timeout, TimeUnit unit) {
        this(heartRate, timeout, unit, DEFAULT_TIMEOUT_CALLBACK);
    }

    public HeartPlugin(int heartRate, int timeout, TimeUnit timeUnit, TimeoutCallback timeoutCallback) {
        if (timeout > 0 && heartRate >= timeout) {
            throw new IllegalArgumentException("heartRate must little then timeout");
        }
        this.heartRate = timeUnit.toMillis(heartRate);
        this.timeout = timeUnit.toMillis(timeout);
        this.timeoutCallback = timeoutCallback;
    }

    @Override
    public final boolean preProcess(AioSession session, T t) {
        this.sessionMap.put(session, System.currentTimeMillis());
        return !this.isHeartMessage(session, t);
    }

    @Override
    public final void stateEvent(SocketStatus socketStatus, AioSession session, Throwable throwable) {
        switch (socketStatus) {
            case NEW_SESSION: {
                this.sessionMap.put(session, System.currentTimeMillis());
                this.registerHeart(session, this.heartRate);
                break;
            }
            case SESSION_CLOSED: {
                this.sessionMap.remove(session);
                break;
            }
        }
    }

    public abstract void sendHeartRequest(AioSession var1) throws IOException;

    public abstract boolean isHeartMessage(AioSession var1, T var2);

    private void registerHeart(final AioSession session, final long heartRate) {
        if (heartRate <= 0L) {
            Logger.info("session:{} \u56e0\u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4\u4e3a:{},\u7ec8\u6b62\u542f\u52a8\u5fc3\u8df3\u76d1\u6d4b\u4efb\u52a1", session, heartRate);
            return;
        }
        Logger.debug("session:{}\u6ce8\u518c\u5fc3\u8df3\u4efb\u52a1,\u8d85\u65f6\u65f6\u95f4:{}", session, heartRate);
        QuickTimer.SCHEDULED_EXECUTOR_SERVICE.schedule(new TimerTask(){

            @Override
            public void run() {
                if (session.isInvalid()) {
                    HeartPlugin.this.sessionMap.remove(session);
                    Logger.info("session:{} \u5df2\u5931\u6548\uff0c\u79fb\u9664\u5fc3\u8df3\u4efb\u52a1", session);
                    return;
                }
                Long lastTime = HeartPlugin.this.sessionMap.get(session);
                if (null == lastTime) {
                    Logger.warn("session:{} timeout is null", session);
                    lastTime = System.currentTimeMillis();
                    HeartPlugin.this.sessionMap.put(session, lastTime);
                }
                long current = System.currentTimeMillis();
                if (HeartPlugin.this.timeout > 0L && current - lastTime > HeartPlugin.this.timeout) {
                    HeartPlugin.this.timeoutCallback.callback(session, lastTime);
                } else if (current - lastTime > heartRate) {
                    try {
                        HeartPlugin.this.sendHeartRequest(session);
                        session.writeBuffer().flush();
                    }
                    catch (IOException e) {
                        Logger.error("heart exception,will close session:{}", session, e);
                        session.close(true);
                    }
                }
                HeartPlugin.this.registerHeart(session, heartRate);
            }
        }, heartRate, TimeUnit.MILLISECONDS);
    }

    public static interface TimeoutCallback {
        public void callback(AioSession var1, long var2);
    }
}

